/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.ParticleMotionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.FilterTarget;
import edu.sc.seis.gee.task.NullCrosshairTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ParticleCreationTask
extends NullCrosshairTask
implements Task,
FilterTarget {
    private String windowName = "Particle Motion";
    private TaskAction colSeisTA;
    private ParticleMotionDisplay particleDisplay;
    private JFrame parMoFrame;
    private Map params;
    private TaskAction crosshairAction;

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (params.containsKey("particleWindowName")) {
            this.windowName = (String)params.get("particleWindowName");
        }
        if (!params.containsKey("ColumnSeismogramTask")) {
            throw new ConfigurationException("ParticleCreationTask requires a ColumnSeismogramTask as part of its config under the name \"Column Seismogram Task\"");
        }
        this.colSeisTA = CommonAccess.getCommonAccess().getTaskAction((String)params.get("ColumnSeismogramTask"));
    }

    @Override
    public void destroy() {
        this.particleDisplay = null;
    }

    public void createParticleDisplay(SeismogramDisplay creator) {
        DataSetSeismogram[] seismos = creator.getSeismograms();
        TimeConfig tc = creator.getTimeConfig();
        if (seismos.length > 0) {
            if (this.particleDisplay == null) {
                this.particleDisplay = new ParticleMotionDisplay(seismos[0], tc, creator.getColor());
                for (int i = 1; i < seismos.length; ++i) {
                    this.particleDisplay.addParticleMotionDisplay(seismos[i], tc, creator.getColor());
                }
                if (this.particleDisplay.initialized()) {
                    FrameManager manager = FrameManager.getManager();
                    this.parMoFrame = manager.createNewChild(this.windowName, manager.getCurrentMainFrame(), new Dimension(400, 400), (JPanel)this.particleDisplay);
                    this.parMoFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            ParticleCreationTask.this.particleDisplay = null;
                        }
                    });
                    this.parMoFrame.show();
                } else {
                    this.particleDisplay = null;
                    JOptionPane.showMessageDialog(null, "The other components weren't found to create the Particle Motion Display, so it can't be created.", "Other Components not found", 2);
                }
            } else {
                for (int i = 0; i < seismos.length; ++i) {
                    this.particleDisplay.addParticleMotionDisplay(seismos[i], tc, creator.getColor());
                }
                this.parMoFrame.show();
                if (this.parMoFrame.getState() == 1) {
                    this.parMoFrame.setState(0);
                }
            }
        }
    }

    public void mouseClicked(SDMouseEvent me) {
        try {
            ColumnSeismogramTask colSeis = (ColumnSeismogramTask)this.colSeisTA.getTask();
            if (me.getDisplay() instanceof BasicSeismogramDisplay) {
                BasicSeismogramDisplay disp = (BasicSeismogramDisplay)me.getDisplay();
                if (disp.getParentDisplay() == colSeis.getDisplay()) {
                    this.createParticleDisplay((SeismogramDisplay)disp);
                } else {
                    JOptionPane.showMessageDialog(me.getComponent(), "Particle Motion plots can only be generated from the Pick Zone window.", "This window doesn't support particle motion", 2);
                }
            }
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((String)"the column seismogram task passed in to ParticleCreationTask isn't being initialized properly", (Throwable)e);
        }
    }

    @Override
    public void applyFilter(NamedFilter filter, boolean visible) {
        if (this.particleDisplay != null) {
            if (visible) {
                this.particleDisplay.add(filter);
            } else {
                this.particleDisplay.remove(filter);
            }
        }
    }

    @Override
    public void setOriginal(boolean visible) {
        if (this.particleDisplay != null) {
            this.particleDisplay.setOriginal(visible);
        }
    }
}

