/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.proj.Projection;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.display.EventTableModel;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.DepthEventColorizer;
import edu.sc.seis.fissuresUtil.map.colorizer.event.EventColorizer;
import edu.sc.seis.fissuresUtil.map.layers.ChannelChooserLayer;
import edu.sc.seis.fissuresUtil.map.layers.EventLayer;
import edu.sc.seis.fissuresUtil.map.layers.EventTableLayer;
import edu.sc.seis.fissuresUtil.map.layers.ShapeLayerPropertiesHandler;
import edu.sc.seis.fissuresUtil.map.layers.StationLayer;
import edu.sc.seis.fissuresUtil.map.projections.ProjectionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.MapLegendTask;
import edu.sc.seis.gee.task.QueryEventsTask;
import edu.sc.seis.gee.task.SAXTask;
import edu.sc.seis.gee.task.ShowEventsTask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OpenMapTask
extends JPanel
implements SAXTask {
    private ChannelChooserTask channelChooserTask;
    private OpenMap map;
    private MapLegendTask legend;
    private LatLonPoint centerLLP = null;
    private float zoom;
    private List shapeLayerProps = new ArrayList();
    private Projection proj = null;
    private Map params;
    private MapSetup setup;
    private ShowEventsTask showEventsTask;
    private ChannelChooserLoader channelLoader;
    private EventLoader eventLoader;
    private static Logger logger = LoggerFactory.getLogger(OpenMapTask.class);

    @Override
    public void destroy() {
    }

    @Override
    public void configure(Map configParams) throws ConfigurationException {
        this.params = configParams;
        this.setup = new MapSetup(configParams);
        this.setup.setup();
    }

    @Override
    public void invoke() {
        this.channelLoader.start();
        this.eventLoader.start();
    }

    protected OpenMap getOpenMap() {
        return this.map;
    }

    protected LatLonPoint getCenter() {
        return this.centerLLP;
    }

    protected LatLonPoint getUpperLeftCorner() {
        return this.map.getMapBean().getProjection().getUpperLeft();
    }

    protected LatLonPoint getLowerRightCorner() {
        return this.map.getMapBean().getProjection().getLowerRight();
    }

    protected float getScale() {
        return this.zoom;
    }

    @Override
    public AbstractHandler getConfigureHandler(String name, XMLReader parser, AbstractHandler parent) {
        if (name.equals("shapeLayers")) {
            return new ShapeLayerHandler(parser, parent);
        }
        if (name.equals("view")) {
            return new MapViewHandler(parser, parent);
        }
        return null;
    }

    private class EventLoader
    extends Thread {
        Map paramMap;
        ShowEventsTask showEvents;
        MapSetup setup;
        boolean autoSelect;
        boolean goBackInTime;

        public EventLoader(Map params, ShowEventsTask set, MapSetup setup) {
            this.paramMap = params;
            this.showEvents = set;
            this.setup = setup;
            this.autoSelect = true;
            if (params.containsKey("autoSelectEvent")) {
                this.autoSelect = Boolean.getBoolean((String)params.get("autoSelectEvent"));
            }
            this.goBackInTime = true;
            if (params.containsKey("goBackInTime")) {
                this.goBackInTime = Boolean.getBoolean((String)params.get("goBackInTime"));
            }
        }

        @Override
        public void run() {
            try {
                if (this.goBackInTime) {
                    String taskId = (String)this.paramMap.get("bigEvents");
                    TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(taskId);
                    QueryEventsTask queryBigEvents = (QueryEventsTask)taskAction.getTask();
                    ProxyEventAccessOperations[] events = queryBigEvents.queryEvents();
                    TimeInterval oneWeek = new TimeInterval(7.0, UnitImpl.DAY);
                    for (int i = 0; i < 4 && events.length == 0; ++i) {
                        MicroSecondDate curStart = new MicroSecondDate(queryBigEvents.getStartTime());
                        queryBigEvents.setStartTime((Date)curStart.subtract(oneWeek));
                        events = queryBigEvents.queryEvents();
                    }
                }
                if (this.autoSelect) {
                    float mag = 0.0f;
                    int rowNum = 0;
                    EventAccessOperations[] events = this.showEvents.getEventTableModel().getAllEvents();
                    if (events.length > 0) {
                        for (int i = 0; i < events.length; ++i) {
                            OriginImpl prefOrigin = EventUtil.extractOrigin((EventAccessOperations)events[i]);
                            float curMag = prefOrigin.getMagnitudes()[0].value;
                            if (!(curMag > mag)) continue;
                            mag = curMag;
                            rowNum = i;
                        }
                        if (this.showEvents.getEventTableModel().getAllEvents().length > 0) {
                            this.showEvents.getEventSelectionModel().setSelectionInterval(rowNum, rowNum);
                        }
                    }
                }
            }
            catch (Throwable ee) {
                GlobalExceptionHandler.handle((Throwable)ee);
            }
            this.setup.eventsFinished();
        }
    }

    private class ChannelChooserLoader
    extends Thread {
        Map paramMap;
        MapSetup setup;

        public ChannelChooserLoader(Map params, MapSetup setup) {
            this.paramMap = params;
            this.setup = setup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.info("ChannelChooserLoader in OpenMapTask run");
                String channelChooserId = (String)this.paramMap.get("channelChooserTask");
                TaskAction channelChooserAction = CommonAccess.getCommonAccess().getTaskAction(channelChooserId);
                OpenMapTask.this.channelChooserTask = (ChannelChooserTask)channelChooserAction.getTask();
                ChannelChooserLayer stationLayer = new ChannelChooserLayer(OpenMapTask.this.channelChooserTask.getChannelChooser());
                OpenMapTask.this.map.setStationLayer((StationLayer)stationLayer);
                logger.info("ChannelChooserLoader in OpenMapTask run done");
            }
            catch (Throwable e) {
                GlobalExceptionHandler.handle((String)"Problem getting stations for map", (Throwable)e);
            }
            finally {
                this.setup.chooserFinished();
            }
        }
    }

    private class MapView {
        public String name = null;
        public float upperLeftLat = Float.NaN;
        public float upperLeftLon = Float.NaN;
        public float centerLat = Float.NaN;
        public float centerLon = Float.NaN;
        public float lowerRightLat = Float.NaN;
        public float lowerRightLon = Float.NaN;

        private MapView() {
        }

        public Map getValueMap() {
            if (this.name == null || Float.isNaN(this.upperLeftLat) || Float.isNaN(this.upperLeftLon) || Float.isNaN(this.centerLat) || Float.isNaN(this.centerLon) || Float.isNaN(this.lowerRightLat) || Float.isNaN(this.lowerRightLon)) {
                return null;
            }
            HashMap<String, String> propMap = new HashMap<String, String>();
            propMap.put(this.name + ".upperLeftLat", this.upperLeftLat + "");
            propMap.put(this.name + ".upperLeftLon", this.upperLeftLon + "");
            propMap.put(this.name + ".centerLat", this.centerLat + "");
            propMap.put(this.name + ".centerLon", this.centerLon + "");
            propMap.put(this.name + ".lowerRightLat", this.lowerRightLat + "");
            propMap.put(this.name + ".lowerRightLon", this.lowerRightLon + "");
            return propMap;
        }
    }

    private final class MapViewHandler
    extends AbstractHandler {
        private String lastParsedString;
        private MapView cur;

        public MapViewHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
            this.lastParsedString = "";
            this.cur = new MapView();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.lastParsedString = this.lastParsedString.trim();
            if (localName.equals("name")) {
                this.cur.name = this.lastParsedString;
            } else if (localName.equals("upperLeftLat")) {
                this.cur.upperLeftLat = Float.parseFloat(this.lastParsedString);
            } else if (localName.equals("upperLeftLon")) {
                this.cur.upperLeftLon = Float.parseFloat(this.lastParsedString);
            } else if (localName.equals("centerLat")) {
                this.cur.centerLat = Float.parseFloat(this.lastParsedString);
            } else if (localName.equals("centerLon")) {
                this.cur.centerLon = Float.parseFloat(this.lastParsedString);
            } else if (localName.equals("lowerRightLat")) {
                this.cur.lowerRightLat = Float.parseFloat(this.lastParsedString);
            } else if (localName.equals("lowerRightLon")) {
                this.cur.lowerRightLon = Float.parseFloat(this.lastParsedString);
            } else if (localName.equals("complexValue")) {
                Map viewProps = this.cur.getValueMap();
                ProjectionHandler projectionHandler = viewProps != null ? new ProjectionHandler(this.cur.getValueMap(), this.cur.name) : (this.cur.name != null ? new ProjectionHandler(this.cur.name) : new ProjectionHandler("World"));
                OpenMapTask.this.proj = projectionHandler.getProjeciton();
                super.endElement(namespaceURI, localName, qName);
            }
            this.lastParsedString = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.lastParsedString = this.lastParsedString + new String(ch, start, length);
        }
    }

    private class ShapeLayerPropHolder {
        public String name;
        public String shapefile;
        public String fillColor;
        public String lineColor;
        public int lineWidth = -1;
        public int threshold = -1;

        private ShapeLayerPropHolder() {
        }
    }

    private final class ShapeLayerHandler
    extends AbstractHandler {
        private boolean alreadyRead;
        private String lastParsedString;
        private ShapeLayerPropHolder cur;

        public ShapeLayerHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
            this.alreadyRead = false;
            this.lastParsedString = "";
            this.alreadyRead = !OpenMapTask.this.shapeLayerProps.isEmpty();
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.lastParsedString = this.lastParsedString.trim();
            if (!this.alreadyRead) {
                if (localName.equals("shapeLayer")) {
                    OpenMapTask.this.shapeLayerProps.add(ShapeLayerPropertiesHandler.getProperties((String)this.cur.name, (String)this.cur.shapefile, (String)this.cur.fillColor, (int)this.cur.lineWidth, (int)this.cur.threshold, (String)this.cur.lineColor));
                } else if (localName.equals("name")) {
                    this.cur.name = this.lastParsedString;
                } else if (localName.equals("shapefile")) {
                    this.cur.shapefile = this.lastParsedString;
                } else if (localName.equals("fillColor")) {
                    this.cur.fillColor = this.lastParsedString;
                } else if (localName.equals("overviewLineWidth")) {
                    this.cur.lineWidth = Integer.parseInt(this.lastParsedString);
                } else if (localName.equals("lineWidthThreshold")) {
                    this.cur.threshold = Integer.parseInt(this.lastParsedString);
                } else if (localName.equals("lineColor")) {
                    this.cur.lineColor = this.lastParsedString;
                }
            }
            if (localName.equals("complexValue")) {
                super.endElement(namespaceURI, localName, qName);
            }
            this.lastParsedString = "";
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.lastParsedString = this.lastParsedString + new String(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (localName.equals("shapeLayer")) {
                this.cur = new ShapeLayerPropHolder();
            }
        }
    }

    private class MapSetup
    extends AbstractJob {
        private Map params;
        private boolean eventsDone;
        private boolean chooserDone;

        public MapSetup(Map params) {
            super("Map Setup");
            this.eventsDone = false;
            this.chooserDone = false;
            this.params = params;
        }

        public synchronized void chooserFinished() {
            this.chooserDone = true;
            if (this.eventsDone) {
                this.setFinished();
            } else {
                this.setStatus("Getting events");
            }
        }

        public synchronized void eventsFinished() {
            this.eventsDone = true;
            if (this.chooserDone) {
                this.setFinished();
            } else {
                this.setStatus("Getting stations");
            }
        }

        public void runJob() {
        }

        public void setup() throws ConfigurationException {
            this.setStatus("Getting Events");
            String taskId = (String)this.params.get("eventsourceid");
            if (taskId == null || taskId.length() == 0) {
                throw new ConfigurationException("showEventsTask must be set in configuration file, showEventsTask = '" + taskId + "'");
            }
            TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(taskId);
            OpenMapTask.this.showEventsTask = (ShowEventsTask)taskAction.getTask();
            EventTableModel etm = OpenMapTask.this.showEventsTask.getEventTableModel();
            this.setStatus("Getting legend");
            taskId = (String)this.params.get("legend");
            if (taskId == null || taskId.length() == 0) {
                throw new ConfigurationException("legendTask must be set in configuration file, legendTask = '" + taskId + "'");
            }
            taskAction = CommonAccess.getCommonAccess().getTaskAction(taskId);
            OpenMapTask.this.legend = (MapLegendTask)taskAction.getTask();
            if (this.params.containsKey("zoom_factor")) {
                this.setStatus("Getting zoom factor");
                String zoomString = (String)this.params.get("zoom_factor");
                OpenMapTask.this.zoom = Float.parseFloat(zoomString);
            } else {
                OpenMapTask.this.zoom = Float.NaN;
            }
            if (this.params.containsKey("center_lat") && this.params.containsKey("center_lon") && OpenMapTask.this.proj == null) {
                this.setStatus("Getting center point");
                float lat = Float.parseFloat((String)this.params.get("center_lat"));
                float lon = Float.parseFloat((String)this.params.get("center_lon"));
                OpenMapTask.this.centerLLP = new LatLonPoint(lat, lon);
            }
            this.setStatus("Creating map");
            Properties[] props = OpenMapTask.this.shapeLayerProps.toArray(new Properties[0]);
            if (OpenMapTask.this.proj != null) {
                OpenMapTask.this.map = new OpenMap(props, OpenMapTask.this.proj);
            } else {
                OpenMapTask.this.map = new OpenMap(props);
            }
            EventTableLayer eventLayer = new EventTableLayer(etm, OpenMapTask.this.showEventsTask.getEventSelectionModel(), OpenMapTask.this.map, (EventColorizer)new DepthEventColorizer());
            OpenMapTask.this.map.setEventLayer((EventLayer)eventLayer);
            if (OpenMapTask.this.proj == null && !Float.isNaN(OpenMapTask.this.zoom)) {
                OpenMapTask.this.map.setZoom(OpenMapTask.this.zoom);
            }
            if (OpenMapTask.this.proj == null && OpenMapTask.this.centerLLP != null) {
                OpenMapTask.this.map.getMapBean().center(new CenterEvent((Object)this, OpenMapTask.this.centerLLP.getLatitude(), OpenMapTask.this.centerLLP.getLongitude()));
            }
            OpenMapTask.this.setLayout(new BorderLayout());
            OpenMapTask.this.add((Component)OpenMapTask.this.map, "Center");
            OpenMapTask.this.add((Component)OpenMapTask.this.legend.getLegend(), "North");
            this.setStatus("Getting stations and events");
            OpenMapTask.this.channelLoader = new ChannelChooserLoader(this.params, OpenMapTask.this.setup);
            OpenMapTask.this.eventLoader = new EventLoader(this.params, OpenMapTask.this.showEventsTask, OpenMapTask.this.setup);
        }
    }
}

