/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserException;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserSource;
import edu.sc.seis.fissuresUtil.chooser.NameListCellRenderer;
import edu.sc.seis.fissuresUtil.chooser.NetworkFromSource;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class NetworkAddTask
implements GUITask {
    JPanel panel = null;
    JList networkList;
    DefaultListModel networks;
    ChannelChooserTask channelChooserTask;
    Map params;
    private static Logger logger = Logger.getLogger(NetworkAddTask.class);

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        logger.debug((Object)"configure");
        this.params = params;
        String chanChooserId = (String)params.get("channelChooserTask");
        TaskAction chanChooserAction = CommonAccess.getCommonAccess().getTaskAction(chanChooserId);
        this.channelChooserTask = (ChannelChooserTask)chanChooserAction.getTask();
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public JComponent getGUI() throws Exception {
        if (this.panel == null) {
            logger.debug((Object)"Panel is null, initPanel");
            this.panel = this.initPanel();
        }
        return this.panel;
    }

    @Override
    public void invoke() throws Exception {
    }

    protected JPanel initPanel() throws ConfigurationException {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.networks = new DefaultListModel();
        this.networkList = new JList(this.networks);
        this.networkList.setCellRenderer(new NameListCellRenderer(true, true, true));
        this.networkList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                ListSelectionModel selections = NetworkAddTask.this.networkList.getSelectionModel();
                for (int i = first; i <= last; ++i) {
                    NetworkFromSource net = (NetworkFromSource)NetworkAddTask.this.networks.get(i);
                    if (!selections.isSelectedIndex(i)) continue;
                    NetworkFromSource selectedNet = (NetworkFromSource)NetworkAddTask.this.networks.get(i);
                    try {
                        NetworkAddTask.this.channelChooserTask.getChannelChooser().appendNetwork(selectedNet);
                        continue;
                    }
                    catch (NoNetworkException ex) {
                        GlobalExceptionHandler.handle((String)("Caught no network, ignoring user selection " + i), (Throwable)ex);
                    }
                }
            }
        });
        List<ChannelChooserSource> netDC = this.channelChooserTask.getConfiguredNetworkSources();
        LoadNetworks loader = new LoadNetworks(netDC);
        JobTracker.getTracker().add((Job)loader);
        WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)loader));
        panel.add((Component)new JScrollPane(this.networkList), "Center");
        return panel;
    }

    class LoadNetworks
    extends AbstractJob {
        List<ChannelChooserSource> netDCs;

        LoadNetworks(List<ChannelChooserSource> netDCs) {
            super("Network List Loader");
            this.netDCs = netDCs;
        }

        public void runJob() {
            for (ChannelChooserSource source : this.netDCs) {
                this.setStatus("Getting networks from net datacenter " + source.toString());
                try {
                    List all = source.getNetworks();
                    for (NetworkAttrImpl networkAttrImpl : all) {
                        final NetworkFromSource na = new NetworkFromSource(networkAttrImpl, source);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NetworkAddTask.this.networks.addElement(na);
                                NetworkAddTask.this.networkList.repaint();
                            }
                        });
                    }
                }
                catch (ChannelChooserException e) {
                    GlobalExceptionHandler.handle((String)("Unable to get networks from " + source.toString()), (Throwable)e);
                }
            }
            this.setFinished();
            NetworkAddTask.this.networkList.repaint();
        }
    }
}

