/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.dataset.Organizer;
import edu.sc.seis.fissuresUtil.psn.PSNToFissures;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.psn.PSNEventRecord;
import edu.sc.seis.seisFile.psn.PSNHeader;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Category;

public class LoadSacFile
implements Task {
    public static final Status SUCCESS = new Status("Successfuly Loaded");
    public static final Status UNREADABLE_FILE = new Status("Unreadable File");
    public static final Status UNKNOWN_FORMAT = new Status("Unknown Format");
    boolean autodisplay = true;
    File lastDir = null;
    Map configParams;
    static Category logger = Category.getInstance((String)LoadSacFile.class.getName());

    @Override
    public void invoke() throws ConfigurationException {
        this.showFileGUI();
    }

    @Override
    public void destroy() {
    }

    private void showFileGUI() {
        JFileChooser jfileChooser = new JFileChooser();
        if (this.lastDir != null) {
            jfileChooser.setCurrentDirectory(this.lastDir);
        }
        jfileChooser.setDialogTitle((String)this.configParams.get("gee.task.name"));
        jfileChooser.setFileSelectionMode(2);
        jfileChooser.setMultiSelectionEnabled(true);
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        ChooserRunnable r = new ChooserRunnable(commonAccess, jfileChooser);
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            r.run();
        }
        if (r.chooserStatus == 0) {
            File[] files = jfileChooser.getSelectedFiles();
            this.lastDir = !files[0].isDirectory() ? files[0].getParentFile() : files[0];
            List results = LoadSacFile.load(files, this.autodisplay);
            LoadSacFile.handleLoadResults(results);
        }
    }

    private static void handleLoadResults(List results) {
        if (results.size() == 0) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "No files found in the given directory", "No Files to Load", 0);
        } else {
            LoadSacFile.handleResultsForSomeFound(results);
        }
    }

    private static void handleResultsForSomeFound(List results) {
        ArrayList<FileLoadResult> good = new ArrayList<FileLoadResult>();
        ArrayList<FileLoadResult> bad = new ArrayList<FileLoadResult>();
        ArrayList<FileLoadResult> ugly = new ArrayList<FileLoadResult>();
        for (FileLoadResult result : results) {
            if (result.s == SUCCESS) {
                good.add(result);
                continue;
            }
            if (result.s == UNREADABLE_FILE) {
                bad.add(result);
                continue;
            }
            ugly.add(result);
        }
        if (bad.size() > 0 || ugly.size() > 0) {
            String msg = "";
            String title = "";
            if (results.size() == 1) {
                title = "Unable to Load File";
                msg = ugly.size() > 0 ? "GEE is only able to read SAC, PSN and MSEED." : "GEE was unable to read the given file.";
            } else {
                if (good.size() > 0) {
                    title = "Unable to Load Some Files";
                    msg = "Some files were loaded successfully by GEE.\n";
                } else {
                    title = "Unable to Load Files";
                }
                if (ugly.size() > 0) {
                    msg = msg + "There were some files that weren't SAC, PSN or MSEED.\n";
                }
                if (bad.size() > 0) {
                    msg = msg + "There were some files that were unreadable.\n";
                }
            }
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), msg, title, 0);
        }
    }

    public static List load(File file, boolean autodisplay) {
        return LoadSacFile.load(new File[]{file}, autodisplay);
    }

    public static List load(File[] files, boolean autodisplay) {
        ArrayList results = new ArrayList();
        LoadSacFile.load(files, autodisplay, results);
        return results;
    }

    private static void load(File[] files, boolean autodisplay, List results) {
        for (int i = 0; i < files.length; ++i) {
            LoadSacFile.loadFileOrDirectory(files[i], autodisplay, results);
        }
    }

    public static void loadFileOrDirectory(File file, boolean autodisplay, List results) {
        if (file.isDirectory()) {
            LoadSacFile.load(file.listFiles(), autodisplay, results);
            return;
        }
        if (!file.canRead()) {
            results.add(new FileLoadResult(file, UNREADABLE_FILE));
        } else {
            try {
                LoadSacFile.loadReadableFile(file, autodisplay);
                results.add(new FileLoadResult(file, SUCCESS));
            }
            catch (IOException e) {
                results.add(new FileLoadResult(file, UNKNOWN_FORMAT));
            }
        }
    }

    private static void loadReadableFile(File file, boolean autodisplay) throws IOException {
        if (file.getName().endsWith(".sac")) {
            LoadSacFile.loadSacFile(file, autodisplay);
        } else if (file.getName().endsWith(".mseed")) {
            LoadSacFile.loadMSeedFile(file, autodisplay);
        } else {
            LoadSacFile.loadUnknownExtensionFile(file, autodisplay);
        }
    }

    private static void loadUnknownExtensionFile(File file, boolean autodisplay) throws IOException {
        PSNHeader header = LoadSacFile.getPSNHeader(file.getPath());
        if (header != null) {
            LoadSacFile.loadPSNFile(file, header.getNumRecords(), autodisplay);
        } else {
            try {
                LoadSacFile.loadSacFile(file, autodisplay);
            }
            catch (IOException e) {
                LoadSacFile.loadMSeedFile(file, autodisplay);
            }
        }
    }

    public static void loadMSeedFile(File file, boolean autodisplay) throws IOException {
        CommonAccess common = CommonAccess.getCommonAccess();
        AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded seismogram from mseed file " + file.getName())};
        URLDataSetSeismogram dss = new URLDataSetSeismogram(file.toURL(), SeismogramFileTypes.MSEED, common.getDataSetRoot());
        Organizer organizer = common.getOrganizer();
        organizer.addSeismogram((DataSetSeismogram)dss, audit_info);
        if (autodisplay) {
            LoadSacFile.addToDisplay((DataSetSeismogram)dss);
        }
    }

    public static void loadSacFile(File file, boolean autodisplay) throws IOException {
        CommonAccess common = CommonAccess.getCommonAccess();
        AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded seismogram from sac file " + file.getName())};
        URLDataSetSeismogram dss = new URLDataSetSeismogram(file.toURL(), SeismogramFileTypes.SAC, common.getDataSetRoot());
        SacTimeSeries sac = new SacTimeSeries();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        sac.read((DataInput)dis);
        CacheEvent event = SacToFissures.getEvent((SacTimeSeries)sac);
        ChannelImpl chan = SacToFissures.getChannel((SacTimeSeries)sac);
        Organizer organizer = common.getOrganizer();
        if (event == null) {
            String evdp = "" + sac.getHeader().getEvdp();
            String evla = "" + sac.getHeader().getEvla();
            String evlo = "" + sac.getHeader().getEvlo();
            MicroSecondDate oDate = SacToFissures.getEventOriginTime((SacTimeSeries)sac);
            String o = "" + oDate;
            if (sac.getHeader().getEvdp() == -12345.0f) {
                evdp = "Undefined";
            }
            if (sac.getHeader().getEvla() == -12345.0f) {
                evla = "Undefined";
            }
            if (sac.getHeader().getEvlo() == -12345.0f) {
                evlo = "Undefined";
            }
            if (oDate == null) {
                o = "Undefined";
            }
            logger.warn((Object)("Incomplete event information: EVDP=" + evdp + " EVLA=" + evla + " EVLO=" + evlo + " OTime=" + o));
        }
        if (event != null) {
            organizer.addSeismogram((DataSetSeismogram)dss, (EventAccessOperations)event, audit_info);
            organizer.addChannel((Channel)chan, (EventAccessOperations)event, audit_info);
        } else {
            organizer.addSeismogram((DataSetSeismogram)dss, audit_info);
            organizer.addChannel((Channel)chan, audit_info);
        }
        if (autodisplay) {
            LoadSacFile.addToDisplay((DataSetSeismogram)dss);
        }
    }

    public static void loadPSNFile(File file, int numRecords, boolean autodisplay) throws IOException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String fileName = file.getPath();
        PSNDataFile psnData = new PSNDataFile(fileName);
        AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded seismogram from data file " + fileName)};
        for (int i = 0; i < numRecords; ++i) {
            URLDataSetSeismogram dss = new URLDataSetSeismogram(URLDataSetSeismogram.createPSNURL((URL)file.toURL(), (int)i), SeismogramFileTypes.PSN, commonAccess.getDataSetRoot());
            Organizer organizer = commonAccess.getOrganizer();
            EventAccessOperations event = PSNToFissures.getEvent((PSNDataFile)psnData);
            Channel chan = PSNToFissures.getChannel((PSNEventRecord)psnData.getEventRecords()[i]);
            if (event != null) {
                organizer.addSeismogram((DataSetSeismogram)dss, event, audit_info);
                organizer.addChannel(chan, event, audit_info);
            } else {
                organizer.addSeismogram((DataSetSeismogram)dss, audit_info);
                organizer.addChannel(chan, audit_info);
            }
            if (!autodisplay) continue;
            LoadSacFile.addToDisplay((DataSetSeismogram)dss);
        }
    }

    public static void addToDisplay(DataSetSeismogram seis) {
        LoadSacFile.addToDisplay(seis, true);
    }

    public static void addToDisplay(DataSetSeismogram seis, boolean bringToFront) {
        TaskAction colSeisTA = CommonAccess.getCommonAccess().getTaskAction("colseisdisplay");
        try {
            ColumnSeismogramTask colSeis = (ColumnSeismogramTask)colSeisTA.getTask();
            colSeis.addSeismogram(seis);
            if (bringToFront) {
                colSeisTA.checkDisplayLocation(true);
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public static PSNHeader getPSNHeader(String fileName) {
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            PSNHeader header = new PSNHeader(dis);
            dis.close();
            return header;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void configure(Map params) {
        this.configParams = params;
        if (params.containsKey("autodisplay")) {
            Boolean b = new Boolean((String)params.get("autodisplay"));
            this.autodisplay = b;
        }
    }

    public static void main(String[] args) {
        LoadSacFile.handleLoadResults(LoadSacFile.load(new File[]{new File("classics")}, false));
    }

    private static class Status {
        public final String reason;

        public Status(String reason) {
            this.reason = reason;
        }

        public String toString() {
            return this.reason;
        }
    }

    private static class FileLoadResult {
        public final File f;
        public final Status s;

        public FileLoadResult(File f, Status r) {
            this.f = f;
            this.s = r;
        }

        public String toString() {
            return this.f.getPath() + ": " + this.s;
        }
    }

    private final class ChooserRunnable
    implements Runnable {
        private CommonAccess access;
        private JFileChooser chooser;
        public int chooserStatus;

        private ChooserRunnable(CommonAccess access, JFileChooser chooser) {
            this.access = access;
            this.chooser = chooser;
        }

        @Override
        public void run() {
            this.chooserStatus = this.chooser.showOpenDialog(this.access.getMainFrame());
        }
    }
}

