/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectionEvent;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Category;

public class ImageViewer
extends JPanel
implements Task,
Printable {
    PrinterJob printerJob = null;
    double screenRatio = 0.8;
    int maxWidth = 1024;
    int maxHeight = 768;
    JScrollPane scroll = null;
    protected JPanel pdfPanel = new JPanel();
    static URI URI_DEMO = URI.create("http://www.sc.edu");
    private boolean checkSizing = false;
    private boolean setFrameSize = true;
    protected HashMap nameURLMap = new HashMap();
    boolean guiInit = false;
    private Image image = null;
    protected JLabel imageLabel = new JLabel("no image");
    protected Map params;
    protected JComboBox comboBox = new JComboBox();
    protected DataSetBrowser browser;
    static Category logger = Category.getInstance((String)ImageViewer.class.getName());

    public ImageViewer() {
        super(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageViewer.this.checkSizing = true;
                ImageViewer.this.repaint();
            }
        });
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pf.getImageableX(), pf.getImageableY());
        double scaleX = pf.getImageableWidth() / (double)this.getWidth();
        double scaleY = pf.getImageableHeight() / (double)this.getHeight();
        if (scaleX < 1.0 || scaleY < 1.0) {
            if (scaleX < scaleY) {
                g2.scale(scaleX, scaleX);
            } else {
                g2.scale(scaleY, scaleY);
            }
        }
        this.paint(g2);
        return 0;
    }

    @Override
    public void repaint() {
        if (this.checkSizing) {
            this.fixSize();
        }
        super.repaint();
    }

    private void checkImageSize(JFrame frame) {
        Dimension desiredImageSize = this.imageLabel.getPreferredSize();
        this.add(this.imageLabel);
        Dimension curPanelSize = this.getSize();
        Dimension internalFrame = frame.getContentPane().getSize();
        int newWidth = curPanelSize.width;
        int newHeight = curPanelSize.height;
        if (curPanelSize.width < desiredImageSize.width) {
            int otherWidth = internalFrame.width - curPanelSize.width;
            newWidth = desiredImageSize.width + otherWidth;
        }
        if (curPanelSize.height < desiredImageSize.height) {
            int otherHeight = internalFrame.height - curPanelSize.height;
            newHeight = desiredImageSize.height + otherHeight;
        }
        if (newWidth > curPanelSize.width || newHeight > curPanelSize.height) {
            this.removeAll();
            if (newWidth < this.maxWidth && newHeight < this.maxHeight && this.setFrameSize) {
                this.add(this.imageLabel);
            } else {
                if (this.maxWidth < newWidth && this.maxWidth > internalFrame.width) {
                    newWidth = this.maxWidth;
                }
                if (this.maxHeight < newHeight && this.maxHeight > internalFrame.height) {
                    newHeight = this.maxHeight;
                }
                if (this.scroll == null) {
                    this.scroll = new JScrollPane(20, 30);
                }
                this.add(this.scroll);
                this.scroll.getViewport().removeAll();
                this.scroll.getViewport().setPreferredSize(this.imageLabel.getPreferredSize());
                this.scroll.getViewport().add(this.imageLabel);
            }
            if (this.setFrameSize) {
                frame.setSize(newWidth, newHeight);
            }
        } else {
            this.removeAll();
            this.add(this.imageLabel);
        }
        this.revalidate();
    }

    private void fixSize() {
        if (this.image == null) {
            return;
        }
        Container con = this.getParent();
        if (con == null) {
            return;
        }
        while (!(con instanceof JFrame)) {
            if ((con = con.getParent()) != null) continue;
            return;
        }
        this.checkSizing = false;
        this.checkImageSize((JFrame)con);
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (params.containsKey("resizeFrame")) {
            this.setFrameSize = Boolean.valueOf((String)params.get("resizeFrame"));
        }
        if (params.containsKey("datasetbrowser")) {
            String browserId = (String)params.get("datasetbrowser");
            TaskAction browserAction = CommonAccess.getCommonAccess().getTaskAction(browserId);
            this.browser = (DataSetBrowser)browserAction.getTask();
            this.browser.addParameterSelectedListener(new ParameterSelectedListener(){

                @Override
                public void parameterSelected(ParameterSelectionEvent p) {
                    if (p.isSelected()) {
                        Object param = p.getValue();
                        String st_url = param instanceof String ? (String)param : (param instanceof ParameterRef ? ((ParameterRef)param).creator : "none");
                        try {
                            URL given_url;
                            Object o = p.getDataSet().getParameter("xml:base");
                            if (o != null && o instanceof String) {
                                String baseStr = (String)o;
                                URL base = new URL(baseStr);
                                given_url = new URL(base, st_url);
                            } else {
                                given_url = new URL(st_url);
                            }
                            ImageViewer.this.addURL(p.getName(), given_url);
                            ImageViewer.this.setImage(given_url);
                            ImageViewer.this.imageLabel.repaint();
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)("Bad image url, " + st_url), (Throwable)e);
                        }
                    }
                }
            });
        }
        for (Object key : params.keySet()) {
            URL given_url;
            String st_url;
            String name;
            String stkey = (String)key;
            if (stkey.startsWith("url_image")) {
                name = stkey.substring(8);
                st_url = (String)params.get(key);
                try {
                    given_url = new URL(st_url);
                    this.addURL(name, given_url);
                    if (this.image != null) continue;
                    this.setImage(given_url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Image Viewer could not parse url " + st_url, e);
                }
            }
            if (!stkey.startsWith("image_jar_")) continue;
            name = stkey.substring("image_jar_".length());
            st_url = (String)params.get(key);
            given_url = this.getClass().getClassLoader().getResource(st_url);
            this.addURL(name, given_url);
            if (this.image != null) continue;
            this.setImage(given_url);
        }
        TaskAction taskAction = (TaskAction)params.get("gee.task.taskAction");
        taskAction.addToToolBar(this.comboBox);
        this.comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    logger.debug((Object)("select " + e.getItem()));
                    ImageViewer.this.setImage((URL)ImageViewer.this.nameURLMap.get(e.getItem()));
                }
            }
        });
    }

    @Override
    public void destroy() {
    }

    public void retrieveImages(DataSet dataSet) {
        logger.debug((Object)("The NAME of THE dataset in RETRIEVE IMAGES is " + dataSet.getName()));
        String[] paramNames = dataSet.getParameterNames();
        URL base = null;
        Object o = dataSet.getParameter("xml:base");
        if (o != null && o instanceof String) {
            String baseStr = (String)o;
            try {
                base = new URL(baseStr);
            }
            catch (MalformedURLException e) {
                logger.warn((Object)("Problem with url: " + baseStr), (Throwable)e);
            }
        }
        for (int i = 0; i < paramNames.length; ++i) {
            logger.debug((Object)("Param name=" + paramNames[i]));
            if (paramNames[i].startsWith("edu.sc.seis.fissuresUtil.xml#EVENT") || paramNames[i].startsWith("edu.sc.seis.fissuresUtil.xml#CHANNEL_")) continue;
            Object param = dataSet.getParameter(paramNames[i]);
            String paramStr = null;
            if (param instanceof String) {
                paramStr = (String)param;
            } else if (param instanceof ParameterRef) {
                paramStr = ((ParameterRef)param).creator;
            }
            if (paramStr == null || paramStr.length() == 0 || !paramStr.endsWith(".gif") && !paramStr.endsWith(".png") && !paramStr.endsWith(".jpg") && !paramStr.endsWith(".pdf") && !paramStr.endsWith(".jpeg")) continue;
            try {
                URL url = base != null ? new URL(base, paramStr) : new URL(paramStr);
                logger.debug((Object)("Adding to image viewer " + paramNames[i] + " " + url.toString()));
                this.addURL(paramNames[i], url);
                continue;
            }
            catch (MalformedURLException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }
    }

    @Override
    public void invoke() {
        if (this.browser != null) {
            DataSet[] datasets = this.browser.getSelectedDataSets();
            if (datasets == null || datasets.length == 0) {
                DataSet dataset = CommonAccess.getCommonAccess().getDataSetRoot();
                this.retrieveImages(dataset);
                String[] dsNames = dataset.getDataSetNames();
                if (dsNames.length == 1) {
                    DataSet child = dataset.getDataSet(dsNames[0]);
                    this.retrieveImages(child);
                } else {
                    String dsNameStr = "";
                    for (int j = 0; j < dsNames.length; ++j) {
                        dsNameStr = dsNameStr + dsNames[j] + " ";
                    }
                    JOptionPane.showMessageDialog(null, "There are " + dsNames.length + " datasets, and none is selected." + dsNameStr, "alert", 0);
                }
            } else {
                for (int counter = 0; counter < datasets.length; ++counter) {
                    DataSet dataset = datasets[counter];
                    this.retrieveImages(dataset);
                }
            }
        }
        this.doGuiInit();
    }

    private void doGuiInit() {
        if (!this.guiInit) {
            this.guiInit = true;
            if (this.image == null) {
                this.imageLabel.setText("No Image");
            } else {
                this.imageLabel.setIcon(new ImageIcon(this.image));
            }
        }
    }

    public void setImage(URL url) {
        if (url.getPath().endsWith(".pdf")) {
            logger.debug((Object)url.getPath());
        } else {
            this.image = Toolkit.getDefaultToolkit().getImage(url);
        }
        this.imageLabel.setIcon(new ImageIcon(this.image));
        this.imageLabel.setText(null);
        this.checkSizing = true;
        this.repaint();
    }

    public void addURL(String name, URL url) {
        String urlName = url.toString();
        if (urlName != null && urlName.length() != 0 && (urlName.endsWith(".gif") || urlName.endsWith(".png") || urlName.endsWith(".jpg") || urlName.endsWith(".pdf") || urlName.endsWith(".jpeg"))) {
            this.nameURLMap.put(name, url);
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                if (!((String)this.comboBox.getItemAt(i)).equals(name)) continue;
                return;
            }
            this.comboBox.addItem(name);
        }
    }
}

