/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HtmlViewerTask
implements GUITask {
    private Map configParams;
    private Map urlMap = new HashMap();
    private JEditorPane editorPane = null;
    private JComboBox comboBox;

    @Override
    public void invoke() {
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
    }

    @Override
    public void destroy() {
    }

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public JComponent getGUI() throws Exception {
        if (this.editorPane == null) {
            this.initializeGUI();
        }
        return new JScrollPane(this.editorPane);
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    public void initializeGUI() throws MalformedURLException, IOException {
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.comboBox = new JComboBox();
        this.comboBox.setEditable(false);
        TaskAction taskAction = (TaskAction)this.configParams.get("gee.task.taskAction");
        taskAction.addToToolBar(this.comboBox);
        this.populateURLField(this.comboBox);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (hle.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL uRL = hle.getURL();
                }
            }
        });
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = (String)HtmlViewerTask.this.comboBox.getSelectedItem();
                if (HtmlViewerTask.this.urlMap.containsKey(filename)) {
                    try {
                        HtmlViewerTask.this.editorPane.setPage((URL)HtmlViewerTask.this.urlMap.get(filename));
                    }
                    catch (IOException ex) {
                        GlobalExceptionHandler.handle((String)("Trouble loading " + filename + ", " + (String)HtmlViewerTask.this.urlMap.get(filename)), (Throwable)ex);
                    }
                }
            }
        });
        String filename = (String)this.comboBox.getItemAt(this.comboBox.getSelectedIndex());
        this.editorPane.setPage((URL)this.urlMap.get(filename));
    }

    private void populateURLField(JComboBox comboBox) throws MalformedURLException {
        for (String key : this.configParams.keySet()) {
            if (key.startsWith("URL_")) {
                comboBox.addItem(key.substring(4));
                this.urlMap.put(key.substring(4), new URL((String)this.configParams.get(key)));
                continue;
            }
            if (!key.startsWith("jar_")) continue;
            comboBox.addItem(key.substring(4));
            URL resource = this.getClass().getClassLoader().getResource((String)this.configParams.get(key));
            this.urlMap.put(key.substring(4), resource);
        }
    }
}

