/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.display.TextTable;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.DataSetCrawler;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class FlagExportTask
extends DataSetCrawler
implements Task {
    private static final String[] template = new String[]{"Flag Name", "Time from Origin (s)", "TauP P Wave (s)", "Prediction Difference (s)", "Distance From Origin (deg)", "Back Azimuth (deg)", "Channel", "Event Name", "Event Latitude", "Event Longitude", "Event Depth (km)", "Magnitude", "Origin Time", "Flag Time"};
    private TaskAction dsbAction;
    private DataSetBrowser dataSetBrowser;
    private TextTable textTable = new TextTable(Flag.getFlagDataHeader((String[])template).length, true);
    private boolean tabDelimited = true;
    private PickOptionsDialogue optionsDialogue = new PickOptionsDialogue();

    @Override
    public void configure(Map params) throws ConfigurationException {
        if (!params.containsKey("DataSetBrowser")) {
            throw new ConfigurationException("FlagExportTask must have a DataSetBrowser associated with it");
        }
        String displayId = (String)params.get("DataSetBrowser");
        this.dsbAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
        this.initCrawler(this.dsbAction);
        this.dataSetBrowser = (DataSetBrowser)this.dsbAction.getTask();
        this.textTable.addRow(Flag.getFlagDataHeader((String[])template), true);
    }

    @Override
    public void invoke() throws Exception {
        this.textTable.clear();
        boolean doneSomething = this.crawlDataSets();
        if (this.textTable.numRows() > 0) {
            this.optionsDialogue.setVisible(true);
        } else if (doneSomething) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "No picks were found in current dataset.", "No Picks", 1);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void crawlAction(DataSetSeismogram seis) {
        EventAccessOperations event = seis.getDataSet().getEvent();
        this.textTable.join(Flag.getFlagData((DataSetSeismogram)seis, (EventAccessOperations)event, (String[])template));
    }

    public void createFileGUI() throws ConfigurationException {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        String[] extensions = new String[]{"txt"};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save Pick Flag Data");
        String defName = "picks.txt";
        fc.setSelectedFile(new File(defName));
        int returnVal = fc.showSaveDialog(FrameManager.getManager().getCurrentFrame());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            PickSaver saver = this.tabDelimited ? new PickSaver(this.textTable.toString("\t"), file) : new PickSaver(this.textTable.toString(), file);
            JobTracker.getTracker().add((Job)saver);
            WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)saver));
        }
    }

    class PickSaver
    extends AbstractJob {
        File file;
        String data;

        PickSaver(String data, File file) {
            super("Save pick flags");
            this.file = file;
            this.data = data;
        }

        public void runJob() {
            FileWriter writer = null;
            try {
                writer = new FileWriter(this.file);
                writer.write(this.data);
            }
            catch (Throwable e) {
                GlobalExceptionHandler.handle((String)"problem saving pick flags.", (Throwable)e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e);
                    }
                }
                this.setFinished();
            }
        }
    }

    private class PickOptionsDialogue
    extends JFrame {
        private JPanel radioButtonPanel;
        private JPanel controlButtonPanel;
        private JRadioButton tabDelimButton;
        private JRadioButton spaceFilledButton;
        private ButtonGroup buttonGroup;
        private Border groupBorder;
        private JButton okButton;
        private JButton cancelButton;

        public PickOptionsDialogue() {
            super("Set Text Formatting");
            this.radioButtonPanel = new JPanel();
            this.controlButtonPanel = new JPanel();
            this.tabDelimButton = new JRadioButton("Tab Delimited");
            this.spaceFilledButton = new JRadioButton("Formatted Table");
            this.buttonGroup = new ButtonGroup();
            this.groupBorder = BorderFactory.createTitledBorder("Text Output");
            this.okButton = new JButton("OK");
            this.cancelButton = new JButton("Cancel");
            this.getContentPane().setLayout(new BorderLayout());
            this.buttonGroup.add(this.tabDelimButton);
            this.buttonGroup.add(this.spaceFilledButton);
            this.radioButtonPanel.setBorder(this.groupBorder);
            this.radioButtonPanel.add(this.tabDelimButton);
            this.radioButtonPanel.add(this.spaceFilledButton);
            this.getContentPane().add((Component)this.radioButtonPanel, "North");
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickOptionsDialogue.this.doOKAction();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickOptionsDialogue.this.doCancelAction();
                }
            });
            this.controlButtonPanel.add(this.okButton);
            this.controlButtonPanel.add(this.cancelButton);
            this.tabDelimButton.setSelected(true);
            this.okButton.setSelected(true);
            this.getContentPane().add((Component)this.radioButtonPanel, "North");
            this.getContentPane().add((Component)this.controlButtonPanel, "South");
            this.pack();
        }

        private void doOKAction() {
            try {
                if (this.tabDelimButton.isSelected()) {
                    FlagExportTask.this.tabDelimited = true;
                } else {
                    FlagExportTask.this.tabDelimited = false;
                }
                this.setVisible(false);
                FlagExportTask.this.createFileGUI();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }

        private void doCancelAction() {
            this.setVisible(false);
        }

        @Override
        public void setVisible(boolean b) {
            this.setLocationRelativeTo(FrameManager.getManager().getCurrentMainFrame());
            super.setVisible(b);
        }
    }
}

