/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.task.LoadDataSetTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class FindDataSetsTask
implements Task {
    private String path;
    private PrintWriter pw;
    private Map configParams;
    private LoadDataSetTask loadDataSetTask = new LoadDataSetTask();

    public FindDataSetsTask(String path) {
        this.path = path;
        try {
            this.pw = new PrintWriter(new BufferedWriter(new FileWriter("/home/telukutl/gee/datasetsxml.xml")));
        }
        catch (FileNotFoundException fnfe) {
            GlobalExceptionHandler.handle((Throwable)fnfe);
        }
        catch (IOException ioe) {
            GlobalExceptionHandler.handle((String)"Exception caught while writing to the file", (Throwable)ioe);
        }
    }

    @Override
    public void invoke() {
        this.pw.println("<?xml version=\"1.0\">");
        this.generateXMLFile(this.path);
        this.pw.println("</xml>");
        this.pw.close();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void configure(Map params) {
        this.configParams = params;
        String respondId = (String)params.get("respondId");
        TaskAction respondAction = CommonAccess.getCommonAccess().getTaskAction(respondId);
    }

    public void generateXMLFile(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int counter = 0; counter < files.length; ++counter) {
                this.generateXMLFile(files[counter].getAbsolutePath());
            }
        } else {
            String fileName = file.getName();
            String tempFileName = fileName.substring(fileName.length() - 3, fileName.length());
            if (tempFileName.equals(".ds")) {
                this.pw.println("<dataset>");
                this.pw.println("\t<name>" + fileName + "</name>");
                this.pw.println("\t<datasetURL>" + path + "</datasetURL>");
                this.pw.println("</dataset>");
            }
        }
    }
}

