/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.FilterTarget;
import edu.sc.seis.gee.task.Task;
import java.util.Map;
import java.util.StringTokenizer;

public class FilterTask
implements Task {
    protected static int numFilters = 0;
    protected NamedFilter filter;
    protected FilterTarget[] destinations;
    protected Map params;
    protected double lowFreqCorner = 0.0;
    protected double highFreqCorner = 0.05;
    protected int numPoles = 2;
    protected int filterType = 0;

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (!params.containsKey("filterTargets")) {
            throw new ConfigurationException("filter task requires a colSeisDisplay in the configuration");
        }
        String destinationId = (String)params.get("filterTargets");
        this.destinations = FilterTask.parseFilterTargets(destinationId);
        if (params.containsKey("lowFreqCorner")) {
            this.lowFreqCorner = Double.parseDouble((String)params.get("lowFreqCorner"));
        }
        if (params.containsKey("highFreqCorner")) {
            this.highFreqCorner = Double.parseDouble((String)params.get("highFreqCorner"));
        }
        if (params.containsKey("numPoles")) {
            this.numPoles = Integer.parseInt((String)params.get("numPoles"));
        }
        if (params.containsKey("filterType") && ((String)params.get("filterType")).equalsIgnoreCase("two pass")) {
            this.filterType = 1;
        }
        this.filter = new NamedFilter(this.lowFreqCorner, this.highFreqCorner, this.numPoles, this.filterType, (String)params.get("gee.task.name"));
        ++numFilters;
    }

    public static FilterTarget[] parseFilterTargets(String destinationId) throws ConfigurationException {
        CommonAccess ca = CommonAccess.getCommonAccess();
        StringTokenizer destinationTokenizer = new StringTokenizer(destinationId, ",");
        int tokens = destinationTokenizer.countTokens();
        FilterTarget[] destinations = new FilterTarget[tokens];
        for (int i = 0; i < tokens; ++i) {
            String destID = destinationTokenizer.nextToken();
            destinations[i] = (FilterTarget)((Object)ca.getTaskAction(destID).getTask());
        }
        return destinations;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void invoke() {
        this.filter.toggleVisibility();
        for (int i = 0; i < this.destinations.length; ++i) {
            this.destinations[i].applyFilter(this.filter, this.filter.getVisibility());
        }
    }
}

