/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.DataSetCrawler;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.util.Map;

public class DisplayAllTask
extends DataSetCrawler
implements Task {
    protected OrientationFilter filter;
    ColumnSeismogramTask display;
    TaskAction dispAction;
    private DataSetBrowser dataSetBrowser;
    private TaskAction dsbAction;
    private boolean bringToFront = true;
    Map params;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (!params.containsKey("seisDisplay")) {
            throw new ConfigurationException("seisDisplay parameter must defined");
        }
        String displayId = (String)params.get("seisDisplay");
        this.dispAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
        this.display = (ColumnSeismogramTask)this.dispAction.getTask();
        if (params.containsKey("bringToFront")) {
            this.bringToFront = Boolean.getBoolean((String)params.get("bringToFront"));
        }
        if (!params.containsKey("DataSetBrowser")) {
            throw new ConfigurationException("AutoDisplayTask must have a DataSetBrowser associated with it");
        }
        displayId = (String)params.get("DataSetBrowser");
        this.dsbAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
        this.dataSetBrowser = (DataSetBrowser)this.dsbAction.getTask();
        this.initCrawler(this.dsbAction);
        if (params.containsKey("orientation")) {
            String ft = (String)params.get("orientation");
            if (ft.equals("orientation.north")) {
                this.filter = new NFilter();
                return;
            } else if (ft.equals("orientation.vertical")) {
                this.filter = new ZFilter();
                return;
            } else if (ft.equals("orientation.east")) {
                this.filter = new EFilter();
                return;
            } else {
                if (!ft.equals("orientation.horizontal")) throw new ConfigurationException("The orientation " + ft + " does not match any existing filters.  Use one of the orientation names in DefaultParamNames");
                OrientationFilter[] filters = new OrientationFilter[]{new NFilter(), new EFilter()};
                this.filter = new ComboFilter(filters);
            }
            return;
        } else {
            this.filter = new NoFilter();
        }
    }

    @Override
    public void invoke() throws Exception {
        boolean displayedSomething = this.crawlDataSets();
        if (this.bringToFront && displayedSomething) {
            this.dispAction.checkDisplayLocation(true);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void crawlAction(DataSetSeismogram seis) {
        this.display(seis);
    }

    public void display(DataSetSeismogram seis) {
        if (this.filter.filter(seis)) {
            this.display.addSeismogram(seis);
        }
    }

    private class ComboFilter
    implements OrientationFilter {
        private OrientationFilter[] filters;

        private ComboFilter(OrientationFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean filter(DataSetSeismogram seis) {
            for (int i = 0; i < this.filters.length; ++i) {
                if (!this.filters[i].filter(seis)) continue;
                return true;
            }
            return false;
        }
    }

    private class NFilter
    implements OrientationFilter {
        private NFilter() {
        }

        @Override
        public boolean filter(DataSetSeismogram seis) {
            return DisplayUtils.getOrientationName((DataSetSeismogram)seis).equals("North");
        }
    }

    private class EFilter
    implements OrientationFilter {
        private EFilter() {
        }

        @Override
        public boolean filter(DataSetSeismogram seis) {
            return DisplayUtils.getOrientationName((DataSetSeismogram)seis).equals("East");
        }
    }

    private class ZFilter
    implements OrientationFilter {
        private ZFilter() {
        }

        @Override
        public boolean filter(DataSetSeismogram seis) {
            return DisplayUtils.getOrientationName((DataSetSeismogram)seis).equals("Up");
        }
    }

    private class NoFilter
    implements OrientationFilter {
        private NoFilter() {
        }

        @Override
        public boolean filter(DataSetSeismogram seis) {
            return true;
        }
    }

    public static interface OrientationFilter {
        public boolean filter(DataSetSeismogram var1);
    }
}

