/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.configurator.Configuration;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.ConfigSwitchTask;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.Task;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;

public class ChooseConfigTask
extends ConfigSwitchTask
implements GUITask {
    private Task resetTask;
    private String configsFile;
    private Configuration currentConfig;
    private Configuration[] configs;

    @Override
    public void configure(Map params) throws ConfigurationException {
        String resetTaskId;
        this.configsFile = (String)params.get("configsFile");
        if (this.configsFile == null) {
            throw new ConfigurationException("ConfigSwitchTask must have a configsFile param");
        }
        if (NetworkGateKeeper.accessAllowed()) {
            try {
                this.configs = Configuration.loadConfigs(this.configsFile);
            }
            catch (Exception e) {
                throw new ConfigurationException("unable to load the configurations from " + this.configsFile);
            }
        }
        if ((resetTaskId = (String)params.get("resetTaskId")) == null) {
            throw new ConfigurationException("ConfigSwitchTask must have a resetTaskId param");
        }
        this.resetTask = AllTasks.getTaskAction(resetTaskId).getTask();
    }

    @Override
    public void invoke() {
    }

    @Override
    public JComponent getGUI() throws Exception {
        Box mainBox = new Box(1);
        mainBox.add(Box.createVerticalStrut(10));
        mainBox.add(this.makeWebConfigGUI());
        mainBox.add(Box.createVerticalStrut(10));
        mainBox.add(this.makeLoadYourOwnConfigGUI());
        mainBox.add(Box.createVerticalStrut(10));
        return mainBox;
    }

    private Component makeLoadYourOwnConfigGUI() {
        Box horiz = new Box(0);
        horiz.add(Box.createHorizontalGlue());
        final JButton loadLocal = new JButton("Reconfigure GEE from a File");
        horiz.add(loadLocal);
        horiz.add(Box.createHorizontalStrut(20));
        loadLocal.addActionListener(new ActionListener(){
            private JFileChooser jfc;

            @Override
            public void actionPerformed(ActionEvent e) {
                int returnVal;
                if (this.jfc == null) {
                    this.jfc = new JFileChooser();
                }
                if ((returnVal = this.jfc.showOpenDialog(loadLocal)) == 0) {
                    try {
                        URL selected = this.jfc.getSelectedFile().toURL();
                        try {
                            ChooseConfigTask.this.switchConfig(selected.toString());
                        }
                        catch (IOException e2) {
                            GlobalExceptionHandler.handle((String)"Unable to read the given file", (Throwable)e2);
                        }
                        catch (ConfigurationException e2) {
                            GlobalExceptionHandler.handle((String)"Trouble with the chosen config file", (Throwable)e2);
                        }
                    }
                    catch (MalformedURLException e1) {
                        GlobalExceptionHandler.handle((String)"I wouldnt think this possible since I got the URL from a file chooser, but lookie!", (Throwable)e1);
                    }
                }
            }
        });
        JButton loadRemote = new JButton("Reconfigure GEE from a URL");
        loadRemote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String value = (String)JOptionPane.showInputDialog(FrameManager.getManager().getCurrentMainPanel(), "Enter the URL to reconfigure GEE", "Reconfigure from a URL", 3, null, null, "http://");
                if (value != null) {
                    try {
                        new URL(value);
                        try {
                            ChooseConfigTask.this.switchConfig(value);
                        }
                        catch (IOException e1) {
                            GlobalExceptionHandler.handle((String)"Unable to read the given file", (Throwable)e1);
                        }
                        catch (ConfigurationException e1) {
                            GlobalExceptionHandler.handle((String)"Trouble with the chosen config file", (Throwable)e1);
                        }
                    }
                    catch (MalformedURLException e2) {
                        JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentMainPanel(), value + " doesn't appear to be a valid URL.  Try navigating to the config file in your browser, copying the location, and pasting it into the dialog", "Invalid URL", 2);
                    }
                }
            }
        });
        horiz.add(loadRemote);
        horiz.add(Box.createHorizontalStrut(20));
        JButton reset = new JButton("Return to GEE's Initial Screen");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ChooseConfigTask.this.resetTask.invoke();
                }
                catch (Exception e1) {
                    GlobalExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        horiz.add(reset);
        horiz.add(Box.createHorizontalGlue());
        return horiz;
    }

    private JComponent makeWebConfigGUI() throws ConfigurationException {
        if (!NetworkGateKeeper.accessAllowed()) {
            Box webConfigs = new Box(1);
            String title = "<h2> Internet Connection Required: </h2>";
            String message = "<p>This feature requires an Internet Connection. GEE is unable to connect to Internet right now.</p> <p>Check your internet connection and restart GEE. If it still doesn't work, please email <B>geebugs@seis.sc.edu</B> describing the problem. </p>";
            String labelText = "<html>" + title + message + "</html>";
            JLabel errorLabel = new JLabel(labelText, 2);
            webConfigs.add(errorLabel);
            webConfigs.add(Box.createHorizontalStrut(5));
            webConfigs.setBorder(new EtchedBorder());
            return webConfigs;
        }
        Box webConfigs = new Box(1);
        for (int i = 0; i < this.configs.length; ++i) {
            webConfigs.add(this.makeConfigGUI(this.configs[i]));
        }
        JScrollPane scrollableWebConfigs = new JScrollPane(webConfigs);
        scrollableWebConfigs.setBorder(new BevelBorder(0));
        return scrollableWebConfigs;
    }

    private Component makeConfigGUI(Configuration configuration) throws ConfigurationException {
        Box configBox = new Box(0);
        configBox.add(Box.createHorizontalStrut(10));
        configBox.add(this.makeImageLabel(configuration));
        configBox.add(Box.createHorizontalStrut(20));
        configBox.add(this.makeDescAndButtons(configuration));
        configBox.setBorder(new EtchedBorder());
        return configBox;
    }

    private JComponent makeImageLabel(Configuration configuration) throws ConfigurationException {
        URL imageURL;
        String imgLoc = configuration.getImage();
        if (imgLoc.startsWith("http:")) {
            try {
                imageURL = new URL(imgLoc);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("Bad URL " + imgLoc + " for configuration " + configuration.getName() + " image", e);
            }
        } else {
            imageURL = this.getClass().getClassLoader().getResource(imgLoc);
        }
        JLabel imageLabel = new JLabel(new ImageIcon(imageURL));
        return imageLabel;
    }

    private JComponent makeDescAndButtons(Configuration config) {
        Box vertBox = new Box(1);
        vertBox.add(Box.createVerticalGlue());
        vertBox.add(this.makeConfigDescription(config));
        vertBox.add(Box.createVerticalGlue());
        vertBox.add(this.makeSwitchers(config));
        vertBox.add(Box.createVerticalGlue());
        return vertBox;
    }

    private Component makeSwitchers(final Configuration config) {
        Box horizBox = new Box(0);
        int i = 0;
        while (i < config.getNumConfigs()) {
            JButton switcher = new JButton(config.getName(i));
            horizBox.add(switcher);
            if (i != config.getNumConfigs() - 1) {
                horizBox.add(Box.createHorizontalStrut(10));
            }
            final int configIndex = i++;
            switcher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        ChooseConfigTask.this.switchConfig(config.getConfig(configIndex));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return horizBox;
    }

    private JComponent makeConfigDescription(Configuration config) {
        Box horiz = new Box(0);
        String name = "<h2>" + config.getName() + "</h2>";
        String desc = "<p>" + config.getDescription() + "</p>";
        String nameAndDesc = "<html>" + name + desc + "</html>";
        horiz.add(new JLabel(nameAndDesc, 2));
        horiz.add(Box.createHorizontalGlue());
        return horiz;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }
}

