/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CheckListBox
extends JFrame {
    private JPanel panel;
    private List checkBoxList = new ArrayList();

    public CheckListBox(String[] values, String title) {
        super(title);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.getContentPane().add(this.panel);
        this.initGUI(values);
        this.setSize(400, 300);
    }

    private void initGUI(String[] values) {
        JButton closeButton = new JButton("Close Window");
        JButton selectAllButton = new JButton("Select All");
        JPanel toolPanel = new JPanel();
        toolPanel.setLayout(new FlowLayout());
        toolPanel.add(closeButton);
        toolPanel.add(selectAllButton);
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CheckListBox.this.closeDialog();
            }
        });
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CheckListBox.this.selectAll();
            }
        });
        for (int i = 0; i < values.length; ++i) {
            this.addItem(values[i]);
        }
        JScrollPane scrollPane = new JScrollPane(this.panel, 20, 30);
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)toolPanel, "South");
        this.setDefaultCloseOperation(1);
    }

    public void addItem(String element) {
        if (!this.Exists(element)) {
            JCheckBox checkBox = new JCheckBox(element);
            this.checkBoxList.add(checkBox);
            this.panel.add(checkBox);
        }
    }

    private boolean Exists(String inputString) {
        Iterator iter = this.checkBoxList.iterator();
        while (iter.hasNext()) {
            String nodeText = ((JCheckBox)iter.next()).getText();
            if (!inputString.equals(nodeText)) continue;
            return true;
        }
        return false;
    }

    private void closeDialog() {
        this.hide();
    }

    public String[] getSelectedValues() {
        ArrayList<String> selectedValues = new ArrayList<String>();
        for (JCheckBox checkBox : this.checkBoxList) {
            if (!checkBox.isSelected()) continue;
            selectedValues.add(checkBox.getText());
        }
        return selectedValues.toArray(new String[0]);
    }

    public void selectAll() {
        for (JCheckBox checkBox : this.checkBoxList) {
            checkBox.setSelected(true);
        }
    }

    public static void main(String[] args) {
        String[] values = new String[]{"hello", "me", "helloby", "a", "b", "c", "d", "e", "this"};
        CheckListBox checkList = new CheckListBox(values, "CheckListBox");
        checkList.setVisible(true);
        checkList.setDefaultCloseOperation(3);
    }
}

