/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.configurator;

import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.ButtonGroupManager;
import edu.sc.seis.gee.task.TaskAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MenuItemHandler
extends AbstractHandler {
    String taskid = "";
    static Category logger = Category.getInstance((String)MenuItemHandler.class.getName());

    public MenuItemHandler(XMLReader parser, AbstractHandler parent) {
        super(parser, parent);
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (localName.equals("taskid")) {
            this.parser.setContentHandler(new TaskIdHandler(this.parser, this));
        }
    }

    public JMenuItem getMenuItem() throws ConfigurationException {
        if (this.taskid.length() != 0 && AllTasks.getTaskAction(this.taskid) != null) {
            JMenuItem menu;
            TaskAction task = AllTasks.getTaskAction(this.taskid);
            if (task.isToggle()) {
                if (task.getConfigParam("gee.task.buttonGroupId") != null) {
                    menu = new JRadioButtonMenuItem(task);
                    ButtonGroup bg = ButtonGroupManager.get((String)task.getConfigParam("gee.task.buttonGroupId"));
                    bg.add(menu);
                    if (task.getConfigParam("gee.task.buttonModel") != null) {
                        menu.setModel((ButtonModel)task.getConfigParam("gee.task.buttonModel"));
                    } else {
                        task.putConfigParam("gee.task.buttonModel", menu.getModel());
                    }
                } else {
                    menu = new JCheckBoxMenuItem(task);
                    if (task.getConfigParam("gee.task.preselected") != null && task.getConfigParam("gee.task.preselected").equals("true")) {
                        ((JCheckBoxMenuItem)menu).setSelected(true);
                    } else {
                        ((JCheckBoxMenuItem)menu).setSelected(false);
                    }
                }
                menu.setActionCommand(task.getId());
            } else {
                menu = new JMenuItem(AllTasks.getTaskAction(this.taskid));
            }
            return menu;
        }
        logger.error((Object)("Can't find task " + this.taskid));
        JMenuItem noTask = new JMenuItem(this.taskid + " unavailable");
        noTask.setEnabled(false);
        return noTask;
    }

    class TaskIdHandler
    extends AbstractHandler {
        TaskIdHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            MenuItemHandler.this.taskid = MenuItemHandler.this.taskid + new String(ch, start, length);
        }
    }
}

