/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.configurator;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.Start;
import edu.sc.seis.gee.configurator.ActivityHandler;
import edu.sc.seis.gee.configurator.AppendConfigHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.GeeConfigHandler;
import edu.sc.seis.gee.configurator.SimpleContentHandler;
import edu.sc.seis.gee.configurator.SimpleErrorHandler;
import edu.sc.seis.gee.configurator.TaskHandler;
import edu.sc.seis.gee.task.AllTasks;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Configure {
    protected int currentActivity;
    protected Map actions = new HashMap();
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private ErrorHandler errorHandler;
    private GeeConfigHandler contentHandler;
    static Category logger = Category.getInstance((String)Configure.class.getName());

    public void load(Reader xmlFile) throws ConfigurationException {
        this.load(xmlFile, false);
    }

    public void load(Reader xmlFile, boolean validate) throws ConfigurationException {
        this.load(xmlFile, validate, null);
    }

    public void load(Reader xmlFile, boolean validate, String externalSchemaLoc) throws ConfigurationException {
        this.load(xmlFile, validate, externalSchemaLoc, false);
    }

    protected void load(Reader xmlFile, boolean validate, final String externalSchemaLoc, boolean append) throws ConfigurationException {
        try {
            int i;
            if (!append) {
                FrameManager.getManager().reset();
                AllTasks.clear();
                this.currentActivity = 0;
            }
            XMLReader parser = (XMLReader)Class.forName(DEFAULT_PARSER_NAME).newInstance();
            this.errorHandler = new SimpleErrorHandler();
            this.contentHandler = new GeeConfigHandler(parser);
            parser.setContentHandler(this.contentHandler);
            parser.setErrorHandler(this.errorHandler);
            parser.setFeature("http://xml.org/sax/features/validation", validate);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", validate);
            if (externalSchemaLoc != null) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", externalSchemaLoc.toString());
            }
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    try {
                        logger.info((Object)("entity resolve " + externalSchemaLoc + " " + publicId + " " + systemId));
                        if (systemId.equals("http://www.seis.sc.edu/xschema/gee/1.0/configuration.xsd") || systemId.endsWith("geeconfigurator.xsd") || systemId.equals(externalSchemaLoc)) {
                            Class<?> c = this.getClass();
                            URL entityURL = c.getClassLoader().getResource(externalSchemaLoc);
                            InputStream fis = entityURL.openStream();
                            return new InputSource(fis);
                        }
                    }
                    catch (Exception e) {
                        GlobalExceptionHandler.handle((String)"Caught exception in EntityResolver", (Throwable)e);
                    }
                    return null;
                }
            });
            parser.parse(new InputSource(xmlFile));
            AppendConfigHandler[] appends = this.contentHandler.getAppendConfigs();
            Configure[] appendConfigure = new Configure[appends.length];
            for (int i2 = 0; i2 < appends.length; ++i2) {
                appendConfigure[i2] = new Configure();
                appendConfigure[i2].load(Start.getReader(appends[i2].getConfigURL()), validate, externalSchemaLoc, true);
            }
            TaskHandler[] tasks = this.contentHandler.getTasks();
            for (i = 0; i < tasks.length; ++i) {
                AllTasks.assoicateTaskActionWithId(tasks[i].getTaskAction());
            }
            for (i = 0; i < appendConfigure.length; ++i) {
                this.contentHandler.appendActivites(appendConfigure[i].getActivities());
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (SAXParseException e) {
            throw new ConfigurationException("Problem with the configuration file at " + SimpleErrorHandler.getLocationString(e), e);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.toString(), e);
        }
    }

    public void validate(Reader xmlFile, String externalSchemaLoc) throws ConfigurationException {
        try {
            XMLReader parser = (XMLReader)Class.forName(DEFAULT_PARSER_NAME).newInstance();
            this.errorHandler = new SimpleErrorHandler();
            SimpleContentHandler simpleHandler = new SimpleContentHandler(parser);
            parser.setContentHandler(simpleHandler);
            parser.setErrorHandler(this.errorHandler);
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            if (externalSchemaLoc != null) {
                parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", externalSchemaLoc.toString());
            }
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            parser.parse(new InputSource(xmlFile));
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(e.toString(), e);
        }
        catch (SAXParseException e) {
            throw new ConfigurationException("Problem with the configuration file at " + SimpleErrorHandler.getLocationString(e), e);
        }
        catch (SAXException e) {
            throw new ConfigurationException("Problem with the xml parser.", e);
        }
        catch (IOException e) {
            throw new ConfigurationException(e.toString(), e);
        }
    }

    public JMenuBar getMenuBar() throws ConfigurationException {
        if (this.contentHandler == null) {
            return new JMenuBar();
        }
        ActivityHandler[] act = this.contentHandler.getActivities();
        return this.getMenuBar(act[this.currentActivity]);
    }

    public JMenuBar getMenuBar(ActivityHandler curAct) throws ConfigurationException {
        JMenuBar appendBar;
        ActivityHandler[] act = this.contentHandler.getActivities();
        String appendActivityId = curAct.getAppendActivityId();
        if (appendActivityId.length() != 0 && (appendBar = this.getMenuBar(act[this.getActivityIndex(appendActivityId)])) != null) {
            JMenuBar newBar = curAct.getMenuBar();
            for (int i = 0; i < newBar.getMenuCount(); ++i) {
                boolean found = false;
                JMenu newMenu = newBar.getMenu(i);
                for (int j = 0; j < appendBar.getMenuCount(); ++j) {
                    JMenu appendMenu = appendBar.getMenu(j);
                    if (!appendMenu.getText().equals(newMenu.getText())) continue;
                    found = true;
                    Component[] menuItems = newBar.getMenu(i).getMenuComponents();
                    for (int k = 0; k < menuItems.length; ++k) {
                        appendBar.getMenu(j).add(menuItems[k]);
                    }
                }
                if (found) continue;
                appendBar.add(newBar.getMenu(i));
            }
            return appendBar;
        }
        return curAct.getMenuBar();
    }

    public String[] getInitialTasks() throws ConfigurationException {
        ActivityHandler[] act = this.contentHandler.getActivities();
        return this.getInitialTasks(act[this.currentActivity]);
    }

    public String[] getInitialTasks(ActivityHandler curAct) throws ConfigurationException {
        ActivityHandler[] act = this.contentHandler.getActivities();
        String appendActivityId = curAct.getAppendActivityId();
        String[] appendInitialTasks = new String[]{};
        if (appendActivityId.length() != 0) {
            appendInitialTasks = this.getInitialTasks(act[this.getActivityIndex(appendActivityId)]);
        }
        String[] currentInitialTasks = curAct.getInitialTasks();
        String[] tmp = new String[currentInitialTasks.length + appendInitialTasks.length];
        System.arraycopy(appendInitialTasks, 0, tmp, 0, appendInitialTasks.length);
        System.arraycopy(currentInitialTasks, 0, tmp, appendInitialTasks.length, currentInitialTasks.length);
        return tmp;
    }

    public String[] getInactiveTasks() throws ConfigurationException {
        ActivityHandler[] act = this.contentHandler.getActivities();
        return this.getInactiveTasks(act[this.currentActivity]);
    }

    public String[] getInactiveTasks(ActivityHandler curAct) throws ConfigurationException {
        ActivityHandler[] act = this.contentHandler.getActivities();
        String appendActivityId = curAct.getAppendActivityId();
        String[] appendInactiveTasks = new String[]{};
        if (appendActivityId.length() != 0) {
            appendInactiveTasks = this.getInactiveTasks(act[this.getActivityIndex(appendActivityId)]);
        }
        String[] currentInactiveTasks = curAct.getInactiveTasks();
        String[] tmp = new String[currentInactiveTasks.length + appendInactiveTasks.length];
        System.arraycopy(appendInactiveTasks, 0, tmp, 0, appendInactiveTasks.length);
        System.arraycopy(currentInactiveTasks, 0, tmp, appendInactiveTasks.length, currentInactiveTasks.length);
        return tmp;
    }

    public Map getActions() {
        return this.actions;
    }

    public void setActivity(String id) throws ConfigurationException {
        this.currentActivity = this.getActivityIndex(id);
    }

    public int getActivityIndex(String id) throws ConfigurationException {
        ActivityHandler[] act = this.contentHandler.getActivities();
        int i = 0;
        while (!act[i].getId().equals(id)) {
            if (++i != act.length) continue;
            throw new ConfigurationException("Activity " + id + " not found.");
        }
        return i;
    }

    public String getActivityId(int index) {
        ActivityHandler[] act = this.contentHandler.getActivities();
        return act[index].getId();
    }

    public int getCurrentActivityIndex() {
        return this.currentActivity;
    }

    public ActivityHandler[] getActivities() {
        return this.contentHandler.getActivities();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        Configure config = new Configure();
        try {
            InputStream in;
            if (args.length > 0) {
                String filename = args[0];
                in = new BufferedInputStream(new FileInputStream(filename));
            } else {
                String filename = "edu/sc/seis/gee/configurator/DefaultConfig.xml";
                in = config.getClass().getClassLoader().getResourceAsStream(filename);
            }
            String schemaFilename = "edu/sc/seis/gee/configurator/geeconfigurator.xsd";
            URL inURL = config.getClass().getClassLoader().getResource(schemaFilename);
            logger.debug((Object)("inURL=" + inURL));
            config.validate(new BufferedReader(new InputStreamReader(in)), inURL.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

