package edu.sc.seis.gee.task.dataSetBrowser;

import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Category;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;

/**
 * TreeSelectionMediator.java
 *
 *
 * Created: Tue Jun 18 11:24:58 2002
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class TreeSelectionMediator implements TreeSelectionListener {
    public TreeSelectionMediator(){
        this(true);
    }

    public TreeSelectionMediator(boolean active){
        this.active = active;
    }

    /** Actives the mediator, allowing events to propogate to listeners.
     */
    public void activate() {
    active = true;
    }

    /** Deactivates the mediator, causing events not to be sent to listeners
    and discarded instead. */
    public void deactivate() {
    active = false;
    }

    public void addSeismogramSelectedListener(SeismogramSelectedListener l) {
        listenerList.add(SeismogramSelectedListener.class, l);
    }

    public void removeSeismogramSelectedListener(SeismogramSelectedListener l){
        listenerList.remove(SeismogramSelectedListener.class, l);
    }

    public void addParameterSelectedListener(ParameterSelectedListener l) {
        listenerList.add(ParameterSelectedListener.class, l);
    }

    public void removeParameterSelectedListener(ParameterSelectedListener l) {
        listenerList.remove(ParameterSelectedListener.class, l);
    }

    public void addDataSetSelectedListener(DataSetSelectedListener l) {
        listenerList.add(DataSetSelectedListener.class, l);
    }

    public void removeDataSetSelectedListener(DataSetSelectedListener l) {
        listenerList.remove(DataSetSelectedListener.class, l);
    }

    javax.swing.event.EventListenerList listenerList =
        new javax.swing.event.EventListenerList();

    public void valueChanged(TreeSelectionEvent e) {
    // don't process events if we have been deactivated
    if (active == false) {
        return;
    } // end of if (active == false)

        try {

            TreePath[] path = e.getPaths();

            if(path != null) {

                for(int counter = 0; counter < path.length; counter++) {

                    Object treeselected = e.getSource();
                    Object nodeselected = path[counter].getLastPathComponent();
                    int totalnodes = path[counter].getPathCount();

                    if (nodeselected instanceof DataSet) {
                        mediate(e.getSource(),
                                (DataSet)nodeselected,
                                e.isAddedPath(path[counter]));
                    } else if (nodeselected instanceof SeismogramTreeNode) {
                        mediate(e.getSource(),
                                (SeismogramTreeNode)nodeselected,
                                e.isAddedPath(path[counter]));
                    } else if (nodeselected instanceof ParameterTreeNode) {
                        mediate(e.getSource(),
                                (ParameterTreeNode)nodeselected,
                                e.isAddedPath(path[counter]));
                    } else {
                        logger.warn("unknown node type: "+
                                    nodeselected.getClass().toString());
                    } // end of else
                }

            }else {

            } // end of else

        } catch (Throwable ex) {
            GlobalExceptionHandler.handle(ex);
        } // end of try-catch
    }

    protected void mediate(Object source, DataSet dataset, boolean selected){

    }

    protected void mediate(Object source, SeismogramTreeNode seis, boolean selected) {
        SeismogramSelectionEvent event = null;
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();

        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==SeismogramSelectedListener.class) {
                // Lazily create the event:
                if (event == null)
                    event = new SeismogramSelectionEvent(source,
                                                         seis.getSeismogram(),
                                                         selected);
                ((SeismogramSelectedListener)listeners[i+1]).seismogramSelected(event);
            }
        }
    }

    protected void mediate(Object source, ParameterTreeNode paramNode, boolean selected) {
        //Object value = paramNode.getParameter();
        ParameterSelectionEvent event = null;
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();

        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2; i>=0; i-=2) {
            if (listeners[i]==ParameterSelectedListener.class) {
                // Lazily create the event:
                if (event == null) {

                    event = new ParameterSelectionEvent(source,
                                                        paramNode.getDataSet(),
                                                        paramNode.getName(),
                                                        paramNode.getParameterValue(),
                                                        selected);
                }
                ((ParameterSelectedListener)listeners[i+1]).parameterSelected(event);
            }
        }
    }

    private boolean active = true;

    protected static Category logger =
        Category.getInstance(TreeSelectionMediator.class.getName());

}// TreeSelectionMediator
