package edu.sc.seis.gee.task.dataSetBrowser;

import javax.swing.tree.DefaultMutableTreeNode;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;

/**
 * Holds a LocalSeismogram or a xml reference to a seismogram as a tree node.
 *
 * @Created June 6, 2002
 *
 * @author Philip Crotwell
 * @version $Id: SeismogramTreeNode.java 10257 2004-08-31 13:47:25Z groves $
 *
 */



public class SeismogramTreeNode extends DefaultMutableTreeNode {

    /** Instantiate a TreeNode that has a LocalSeismogram object*/
    public SeismogramTreeNode(DataSetSeismogram seis) {
        super(seis, false);
        this.seismogram = seis;
        this.dataset = seis.getDataSet();

        name = seis.getName();
        if(name == null || name.length() == 0) {
            name = seis.toString();
        }
    }


    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {

        return name;
    }

    public DataSetSeismogram getSeismogram() {
        if (seismogram != null) {
            return seismogram;
        } // end of if (seismogram != null)

        return dataset.getDataSetSeismogram(name);
    }

    public String getName() {
        return name;
    }

    public DataSet getDataSet() {
        return dataset;
    }

    private String name;

    private DataSet dataset;

    private DataSetSeismogram seismogram = null;
}
