package edu.sc.seis.gee.task.dataSetBrowser;

import java.util.EventObject;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;


/**
 * SeismogramSelectionEvent.java
 *
 *
 * Created: Tue Jun 18 14:10:56 2002
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class SeismogramSelectionEvent extends EventObject {

    /**
     * Creates a new <code>SeismogramSelectionEvent</code> instance.
     *
     * @param source the ibject that created this event, usually the dataset editor
     * @param seis the selected <code>DataSetSeismogram</code> value
     * @param selected whether or not the seismogram is now selected
     */
    public SeismogramSelectionEvent (Object source,
                                     DataSetSeismogram seis,
                                     boolean selected) {
        super(source);
        this.seis = seis;
        this.selected = selected;
    }

    /**
     * Describe <code>getSeismogram</code> method here.
     *
     * @return a <code>DataSetSeismogram</code> value
     */
    public DataSetSeismogram getSeismogram() {
        if (seis == null) {
            seis = dataset.getDataSetSeismogram(name);
        } // end of if (seis == null)
        return seis;
    }

    /**
     * Describe <code>getDataSet</code> method here.
     *
     * @return a <code>DataSet</code> value
     */
    public DataSet getDataSet() {
        return dataset;
    }

    /**
     * Describe <code>getSeismogramName</code> method here.
     *
     * @return a <code>String</code> value
     */
    public String getSeismogramName() {
        return name;
    }

    /**
     * Describe <code>isSelected</code> method here.
     *
     * @return a <code>boolean</code> value
     */
    public boolean isSelected() {
        return selected;
    }

    private DataSetSeismogram seis = null;

    private boolean selected;

    private String name;

    private DataSet dataset;

}// SeismogramSelectionEvent
