package edu.sc.seis.gee.task.dataSetBrowser;

import javax.swing.tree.DefaultMutableTreeNode;
import edu.sc.seis.fissuresUtil.xml.DataSet;

/**
 * ParameterTreeNode.java
 *
 *
 * Created: Tue Jun 18 09:42:14 2002
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class ParameterTreeNode extends DefaultMutableTreeNode {
    public ParameterTreeNode (DataSet dataset, String name) {
        this.dataset = dataset;
        this.name = name;
        
    }
    
    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return name;
    }

    public Object getParameter() {
        if (param == null) {
            param = dataset.getParameter(name);
        }
        return param;
    }

    public Object getParameterValue() {
        getParameter();
        if (param instanceof org.w3c.dom.Element) {
            org.w3c.dom.Element element = (org.w3c.dom.Element)param;
            return edu.sc.seis.fissuresUtil.xml.XMLParameter.getParameter(element);
        } // end of if (param instanceof Element)

        return param;
    }

    public DataSet getDataSet() {
        return dataset;
    }
    
    public String getName() {
        return name;
    }

    private String name;

    private DataSet dataset;

    private Object param;

}// ParameterTreeNode
