package edu.sc.seis.gee.task.dataSetBrowser;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.StdDataSetParamNames;


/**
 * DataSetTreeCellRenderer.java
 *
 *
 * Created: Fri May 31 14:26:33 2002
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version
 */

public class DataSetTreeCellRenderer extends DefaultTreeCellRenderer {
    public DataSetTreeCellRenderer (){

    }

    public Component getTreeCellRendererComponent(JTree tree,
                                                  Object value,
                                                  boolean sel,
                                                  boolean expanded,
                                                  boolean leaf,
                                                  int row,
                                                  boolean hasFocus) {
        Component orig = super.getTreeCellRendererComponent(tree,
                                                            value,
                                                            sel,
                                                            expanded,
                                                            leaf,
                                                            row,
                                                            hasFocus);

        if (value instanceof DataSet && orig instanceof JLabel) {
            DataSet ds = (DataSet)value;
            String labelStr = ""+ds.getName();
            if (labelStr.length() == 0) {
                labelStr = "ID:"+ds.getId();
            }

            // don't do this as URLDataSetSeismograms load remotely to get event
//
//            String eventRegion = "";
//            EventAccessOperations event = ds.getEvent();
//            if (event != null) {
//                eventRegion = feRegions.getRegionName(event.get_attributes().region);
//                try {
//                    Origin o = event.get_preferred_origin();
//                    if (o.magnitudes.length > 0) {
//                        labelStr += " - "+ o.magnitudes[0].type+
//                            " "+o.magnitudes[0].value;
//                    }
//                } catch (NoPreferredOrigin e) {
//                    // oh well...
//                }
//                if (eventRegion != null && eventRegion.length() > 5) {
//                    labelStr += " "+eventRegion;
//                }
//            } // end of if (ds.get)

            JLabel dsLabel = (JLabel)orig;
            dsLabel.setText(labelStr);
            return dsLabel;
        } // end of if (value instanceof DataSet)

        if (value instanceof ParameterTreeNode && orig instanceof JLabel) {
            ParameterTreeNode paramNode = (ParameterTreeNode)value;
            JLabel paramLabel = (JLabel)orig;
            if (paramNode.getName().equals(StdDataSetParamNames.EVENT)) {
                paramLabel.setText("Event");
            } else  if (paramNode.getName().startsWith(StdDataSetParamNames.CHANNEL)) {
                paramLabel.setText("Channel for "+
                                       paramNode.getName().substring(StdDataSetParamNames.CHANNEL.length()));
            }
            return paramLabel;
        }

        // otherwise
        return orig;
    }

    public static edu.sc.seis.fissuresUtil.display.ParseRegions feRegions
        = edu.sc.seis.fissuresUtil.display.ParseRegions.getInstance();

    private static Logger logger = Logger.getLogger(DataSetTreeCellRenderer.class);

}// DataSetTreeCellRenderer
