package edu.sc.seis.gee.task;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * ToggleOriginalTask.java
 *
 *
 * Created: Mon Jul 15 09:36:46 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class ToggleOriginalTask implements Task {
    public void configure(Map params) throws ConfigurationException{
        this.params = params;
        CommonAccess ca = CommonAccess.getCommonAccess();
        if(params.containsKey("filterTargets")){
            String destinationId = (String)params.get("filterTargets");
            StringTokenizer destinationTokenizer = new StringTokenizer(destinationId,",");
            int tokens = destinationTokenizer.countTokens();
            destinations = new FilterTarget[tokens];
            for (int i = 0; i < tokens; i++){
                String destID = destinationTokenizer.nextToken();
                destinations[i]  = (FilterTarget)ca.getTaskAction(destID).getTask();
            }
        }else {
            throw new ConfigurationException("toggle original task requires a colSeisDisplay in the configuration");
        }
    }
    
    public void invoke(){
        visible = !visible;
        DrawableSeismogram.setDefaultVisibility(visible);
        for (int i = 0; i < destinations.length; i++){
            destinations[i].setOriginal(visible);
        }
    }
    
    public void destroy(){}
    
    private Map params;
    
    private boolean visible = false;
    
    private FilterTarget[] destinations;
    
    Logger logger = Logger.getLogger(ToggleOriginalTask.class);
}// ToggleOriginalTask
