package edu.sc.seis.gee.task;

/**
 * TimeSetterTask.java
 * 
 * @author Created by Charlie Groves
 */
import java.util.Map;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

public abstract class TimeSetterTask implements Task {

    public void configure(Map params) throws ConfigurationException{
        String colSeisId = (String)params.get("colSeisTarget");
        CommonAccess ca = CommonAccess.getCommonAccess();
        colSeisTaskAction = ca.getTaskAction(colSeisId);
    }

    public void invoke() throws ConfigurationException {
        ((ColumnSeismogramTask)colSeisTaskAction.getTask()).setTimeSetter(this);
    }

    public void destroy() {}

    public abstract boolean needsEventInformation();

    public void setTime(SeismogramDisplay disp) {
        TimeConfig curConfig = disp.getTimeConfig();
        if(curConfig instanceof RTTimeRangeConfig) {
            ((RTTimeRangeConfig)curConfig).setInternalConfig(makeConfig());
            disp.setTimeConfig(curConfig);
        } else {
            disp.setTimeConfig(makeConfig());
        }
        if(curConfig != null) {
            disp.getTimeConfig().shaleTime(curConfig.getShift(),
                                           curConfig.getScale());
        }
    }

    public abstract TimeConfig makeConfig();

    private TaskAction colSeisTaskAction;
}