package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;

import javax.swing.JLabel;
import javax.swing.JPanel;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeDecimalFormat;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * TimeAmpPaletteTask.java
 *
 *
 * Created: Wed Jul 10 16:32:27 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class TimeAmpPaletteTask extends JPanel implements Task {

     public void configure(Map params) throws ConfigurationException{
	this.params = params;
	setMinimumSize(new java.awt.Dimension(345, 20));

	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());
	panel.add(ampLabel, BorderLayout.SOUTH);
	panel.add(timeLabel, BorderLayout.NORTH);
	setLayout(new BorderLayout());
	add(panel, BorderLayout.CENTER);

	myTALabeler.configure(params);
     }

    public void invoke() throws ConfigurationException{ 

    }

    public void destroy(){}

    protected class InternalTimeAmpLabel extends TimeAmpLabelTask {
	protected void updateDisplay(BasicSeismogramDisplay display,
				     MicroSecondDate time, QuantityImpl amp) {
	    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
	    calendar.setTime(time);
	    String unitString = "";
	    ThreadSafeDecimalFormat formatter = decimal;
	    if ( ! amp.getUnit().equals(UnitImpl.COUNT)) {
		unitString = amp.getUnit().toString();
	    } else {
		formatter = decimalInt;
	    }	    
	    if (Math.abs(amp.getValue()) > 1000000 
		|| Math.abs(amp.getValue()) < .000001) {
		ampLabel.setText("   Amplitude: "
				 +scientific.format(amp.getValue())
				 +" "+unitString);
	    } else {
		ampLabel.setText("   Amplitude: "+
				 formatter.format(amp.getValue())
				 +" "+unitString);
	    } // end of else
	    
	    
	    timeLabel.setText("   Time: "+
			      timeOutput.format(calendar.getTime()));
	}
    }

    protected ThreadSafeDecimalFormat decimal = new ThreadSafeDecimalFormat("###.##");
    protected ThreadSafeDecimalFormat decimalInt = new ThreadSafeDecimalFormat("#.");
    protected ThreadSafeDecimalFormat scientific = new ThreadSafeDecimalFormat("0.###E0");

    protected SimpleDateFormat timeOutput = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
    protected static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    protected JLabel ampLabel = new JLabel("   Amplitude: ");
    protected JLabel timeLabel = new JLabel("   Time: ");
    protected InternalTimeAmpLabel myTALabeler = new InternalTimeAmpLabel();
    protected Map params;

}// TimeAmpPaletteTask
