package edu.sc.seis.gee.task;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Map;
import javax.swing.JComponent;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * SplashScreen.java
 *
 *
 * Created: Mon Feb 18 10:40:26 2002
 *
 * @author <a href="mailto:crotwell@pooh">Philip Crotwell</a>
 * @version $Id: SplashScreen.java 10257 2004-08-31 13:47:25Z groves $
 */

public class SplashScreen extends JComponent implements Task {
    public SplashScreen (){
	
    }
    
    public void configure(Map params) throws ConfigurationException {
	this.params = params;
	String imageName;
	if (params.containsKey("image")) {
	    imageName = (String)params.get("image");
	} else {
	    throw new ConfigurationException("Splash Image filename not defined");
	} // end of else

	URL url;
	if (imageName.indexOf('/') == -1) {
		    // no directories in imageName, try and find in data/images
		    imageName = "edu/sc/seis/gee/data/images/"
			+imageName;
		    url = getClass().getClassLoader().getResource(imageName);
		} else {
		    try {
			url = new URL(imageName);
		    } catch (java.net.MalformedURLException e) {
			throw new ConfigurationException("Splash Image URL is mbadly formed", e);
		    } // end of try-catch
		} // end of else

	    logo = Toolkit.getDefaultToolkit().getImage(url);
	    MediaTracker mt = new MediaTracker(this);
	    mt.addImage(logo, 0);
	    try {
		mt.waitForID(0);
	    } catch (Exception e) {
		throw new ConfigurationException("Problem loading image for splash screen", e);
	    }
	    setPreferredSize(new Dimension(logo.getWidth(this), 
					   logo.getHeight(this)));
    }

    public void invoke() {

    }

    public void destroy(){}

    public void paintComponent(Graphics g) {
        g.drawImage(logo, 0, 0, this);
    }

    protected Image logo;

    protected Map params;

}// SplashScreen
