/**
 * SeismogramShuckerTask.java
 *
 * @author Created by Philip Oliver-Paull
 */

package edu.sc.seis.gee.task;

import java.awt.event.MouseEvent;
import java.util.Map;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

public class SeismogramShuckerTask extends NullCrosshairTask{

    ColumnSeismogramTask source, destinationDisp;
    TauPPathTask destinationTauPPath;

    /**
     * Method configure
     *
     * @param    params              a  Map
     *
     * @throws   ConfigurationException
     *
     */
    public void configure(Map params) throws ConfigurationException {
        String taskId;
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        TaskAction taskAction;

        taskId = (String)params.get("sourceDisplay");
        if (taskId == null || taskId.length() == 0){
            throw new ConfigurationException("No source Seismogram Display Task defined in config");
        }
        taskAction = commonAccess.getTaskAction(taskId);
        source = (ColumnSeismogramTask)taskAction.getTask();

        if (params.containsKey("destinationDisplay")){
            taskId = (String)params.get("destinationDisplay");
            if (taskId == null || taskId.length() == 0){
                throw new ConfigurationException("No destination Seismogram Display Task defined in config");
            }
            taskAction = commonAccess.getTaskAction(taskId);
            destinationDisp = (ColumnSeismogramTask)taskAction.getTask();
        }

        if (params.containsKey("destinationTauPPath")){
            taskId = (String)params.get("destinationTauPPath");
            if (taskId == null || taskId.length() == 0){
                throw new ConfigurationException("No destination TauP Path Task defined in config");
            }
            taskAction = commonAccess.getTaskAction(taskId);
            destinationTauPPath = (TauPPathTask)taskAction.getTask();
        }

        super.configure(params);
    }



    /**
     * Invoked when the mouse has been clicked on a component.
     */
    public void mouseClicked(MouseEvent e) {
        SeismogramDisplay sourceDisplay = source.getDisplay();
        if (e.getComponent() == sourceDisplay){
            if (sourceDisplay.getDrawables(e) != null){
                DrawableIterator dIt = sourceDisplay.getDrawables(e);
                if(dIt.hasNext()){
                    DrawableSeismogram seis = (DrawableSeismogram)dIt.next();
                    DataSetSeismogram dss = seis.getSeismogram();
                    if (destinationDisp != null){
                        destinationDisp.removeAllDisplays();
                        destinationDisp.addSeismogram(dss);
                        try{
                            destinationTauPPath.displayPath(destinationDisp.getDisplay());
                        }
                        catch(Exception ex){
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
    }

}

