package edu.sc.seis.gee.task;

import edu.sc.seis.gee.configurator.AbstractHandler;

/**
 * Allows a task to be configured via a more flexible method than simple
 * string based name-value pairs. This method allows the task to return a
 * SAX (Simple API for XML) handler when the system encounters a taskconfig
 * element whose value is not a simple string. The returned AbstractHandler
 * should be initialized with the given parent so that control may return to 
 * the normal parsing system at the end of the tag.
 *
 *
 * Created: Wed Jan 15 10:15:22 2003
 *
 * @author <a href="mailto:crotwell@owl.seis.sc.edu">Philip Crotwell</a>
 * @version 1.0
 */

public interface SAXTask extends Task {

    public AbstractHandler getConfigureHandler(String name, 
					       org.xml.sax.XMLReader parser,
					       AbstractHandler parent);

}
