package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * RefreshDisplayTask.java
 *
 *
 * Created: Thu Jul 18 14:01:25 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class RefreshDisplayTask implements Task {
    public void configure(Map params) throws ConfigurationException{ 
	this.params = params;
	if(params.containsKey("colSeisDisplay")){
	    String targetId = (String)params.get("colSeisDisplay");
	    target = ((ColumnSeismogramTask)CommonAccess.getCommonAccess().getTaskAction(targetId).getTask());
	}else {
	    throw new ConfigurationException("toggle original task requires a colSeisDisplay in the configuration");
	}
    }

    public void invoke(){
	target.refreshDisplays();
    }

    public void destroy(){}
    
    protected Map params;

    protected ColumnSeismogramTask target;    
}// RefreshDisplayTask
