package edu.sc.seis.gee.task;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * @author oliverpa Created on Aug 23, 2004
 */
public class PlottableOutputTask extends DisplayOutputTask {

    public PlottableOutputTask() {
        dialogueTitle = "Save Day Viewer as Image";
    }

    public void configure(Map params) throws ConfigurationException {
        configParams = params;
        if(params.containsKey("plottableTask")) {
            String taskId = (String)params.get("plottableTask");
            TaskAction taskAction = CommonAccess.getCommonAccess()
                    .getTaskAction(taskId);
            plottableTask = (PlottableTask)taskAction.getTask();
        } else {
            throw new ConfigurationException("no plottableTask configured");
        }
    }

    protected void save(File file) throws IOException {
        plottableTask.getDisplay().outputToPNG(file);
    }

    private Map configParams;

    private PlottableTask plottableTask;
}