package edu.sc.seis.gee.task;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.ParticleMotionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * ParticleCreationTask.java
 *
 *
 * Created: Thu Jul  4 12:50:52 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class ParticleCreationTask extends NullCrosshairTask implements Task, FilterTarget{
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (params.containsKey("particleWindowName")) {
            windowName = (String)params.get("particleWindowName");
        } // end of if (params.containsKey("particleWindowName"))
        if(params.containsKey("ColumnSeismogramTask")){
            colSeisTA = CommonAccess.getCommonAccess().getTaskAction((String)params.get("ColumnSeismogramTask"));
        }else{
            throw new ConfigurationException("ParticleCreationTask requires a ColumnSeismogramTask as part of its config under the name \"Column Seismogram Task\"");
        }
    }

    public void destroy(){  particleDisplay = null;  }

    public void createParticleDisplay(SeismogramDisplay creator){
        DataSetSeismogram[]  seismos = creator.getSeismograms();
        TimeConfig tc = creator.getTimeConfig();
        if(seismos.length > 0){
            if(particleDisplay == null){
                particleDisplay = new ParticleMotionDisplay(seismos[0],
                                                            tc, creator.getColor());
                for (int i = 1; i < seismos.length; i++) {
                    particleDisplay.addParticleMotionDisplay(seismos[i],
                                                             tc, creator.getColor());
                }
                if(particleDisplay.initialized()){
                    FrameManager manager = FrameManager.getManager();
                    parMoFrame = manager.createNewChild(windowName,
                                                        manager.getCurrentMainFrame(),
                                                        new Dimension(400,400),
                                                        particleDisplay);
                    parMoFrame.addWindowListener(new WindowAdapter(){
                                public void windowClosed(WindowEvent e) {
                                    particleDisplay = null;
                                }
                            });

                    parMoFrame.show();
                }else{
                    particleDisplay = null;
                    JOptionPane.showMessageDialog(null,
                                                  "The other components weren't found to create the Particle Motion Display, so it can't be created.",
                                                  "Other Components not found",
                                                  JOptionPane.WARNING_MESSAGE);
                }
            }else {
                for (int i = 0; i < seismos.length; i++) {
                    particleDisplay.addParticleMotionDisplay(seismos[i],
                                                             tc, creator.getColor());
                }
                parMoFrame.show();
                if (parMoFrame.getState() == JFrame.ICONIFIED) {
                    parMoFrame.setState(JFrame.NORMAL);
                }
            } // end of else
        }
    }

    public void mouseClicked(SDMouseEvent me) {
        try {
            ColumnSeismogramTask colSeis = (ColumnSeismogramTask)colSeisTA.getTask();
            if(me.getDisplay() instanceof BasicSeismogramDisplay){
                BasicSeismogramDisplay disp = (BasicSeismogramDisplay)me.getDisplay();
                if(disp.getParentDisplay() == colSeis.getDisplay()){
                    createParticleDisplay(disp);
                }else{
                    JOptionPane.showMessageDialog(me.getComponent(),
                                                  "Particle Motion plots can only be generated from the Pick Zone window.",
                                                  "This window doesn't support particle motion",
                                                  JOptionPane.WARNING_MESSAGE);
                }
            }
        } catch (ConfigurationException e) {
            GlobalExceptionHandler.handle("the column seismogram task passed in to ParticleCreationTask isn't being initialized properly", e);
        }
    }

    public void applyFilter(NamedFilter filter, boolean visible) {
        if(particleDisplay != null)
            if(visible)
                particleDisplay.add(filter);
            else
                particleDisplay.remove(filter);
    }

    public void setOriginal(boolean visible) {
        if(particleDisplay != null)
            particleDisplay.setOriginal(visible);
    }

    private String windowName = "Particle Motion";

    private TaskAction colSeisTA;

    private ParticleMotionDisplay particleDisplay;

    private JFrame parMoFrame;

    private Map params;

    private TaskAction crosshairAction;

}// ParticleCreationTask
