package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JPanel;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * NewPanel.java
 *
 *
 * Created: Tue Apr  8 14:16:56 2003
 *
 * @author <a href="mailto:crotwell@owl.seis.sc.edu">Philip Crotwell</a>
 * @version 1.0
 */
public class NewMainFrame implements Task {
    public void configure(Map params) throws ConfigurationException {
        if(params.containsKey("PlaceholderImage")){
            CommonAccess ca = CommonAccess.getCommonAccess();
            String placeholderID = (String)params.get("PlaceholderImage");
            placeholderTA = ca.getTaskAction(placeholderID);
        }
    }

    public void invoke() throws Exception {
        FrameManager manager = FrameManager.getManager();
        JFrame frame = manager.createNewMother();
        frame.show();
        JPanel panel = manager.getPanelForFrame(frame);
        if(placeholderTA != null){
            panel.setLayout(new BorderLayout());
            PlaceholderImage image = (PlaceholderImage)placeholderTA.getTask();
            panel.add(image.generateImagePanel());
            panel.revalidate();
        }
    }

    public void destroy() {

    }

    private TaskAction placeholderTA;


} // NewMainFrame
