/**
 * MouseFollowingDrawableTask.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.awt.Cursor;
import edu.sc.seis.fissuresUtil.display.drawable.MovableDrawable;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;



public abstract class MouseMovableTask extends SDMouseAdapter implements Task {
	
	protected MovableDrawable movable;
	protected Cursor cursor;
	
	public void invoke() throws Exception {
		GlobalToolBar.setActive(this);
	}

	public void destroy() {
		GlobalToolBar.remove(this);
	}
	
	public void mouseMoved(SDMouseEvent e){
		updateMovable(e);
	}
	
	public void mouseDragged(SDMouseEvent e){
		updateMovable(e);
	}
	
	public void updateMovable(SDMouseEvent e){
		movable.setXY(e.getX(), e.getY());
		e.getDisplay().repaint();
	}
	
	public void setMovable(MovableDrawable mov){
		movable = mov;
	}
	
	public void setCursor(Cursor curs){
		cursor = curs;
	}
	
	public void mouseEntered(SDMouseEvent e){
		e.getDisplay().add(movable);
		e.getComponent().setCursor(cursor);
	}
	
	public void mouseExited(SDMouseEvent e){
		e.getComponent().setCursor(Cursor.getDefaultCursor());
		e.getDisplay().remove(movable);
		e.getDisplay().repaint();
	}
	
}

