/**
 * MemoryStatus.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee.task;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import edu.sc.seis.gee.configurator.ConfigurationException;



public class MemoryStatus implements GUITask {


    /**
     * Called when reset is invoked on gee or if this task is no longer being used
     *
     */
    public void destroy() {
        // TODO
    }

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can
     * throw a ConfigureException if a required parameter is missing.
     *
     * @param params a <code>Map</code> value
     * @exception ConfigurationException if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
        // TODO
    }

    /** True if this GUI has a "more options" funtionality. More options
     *  appear in a separate panel below the main gui, and can be shown/hidden
     *  with a "Show More Options" and "Hide More Options" button that is
     *  provided automatically is this return true.
     */
    public boolean hasMoreOptions() {
        // TODO
        return false;
    }

    /** Gets the "More Options" GUI component.
     */
    public JComponent getMoreOptionsGUI() {
        // TODO
        return null;
    }

    /**
     bo     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     *
     *
     * @exception Exception if an error occurs
     */
    public void invoke() throws Exception {
        // TODO
    }

    /** Gets the GUI for this Task. Used for interacting with the user
     before and after invoking this Task's action.
     */
    public JComponent getGUI() throws Exception {
        if (gui == null) {
            gui = createGUI();
        }
        updateLabels();
        return gui;
    }

    public JPanel createGUI() {
        JPanel panel = new JPanel();
        panel.setName("Memory Status");
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add(new JLabel("Free Memory"), gbc);
        gbc.gridy++;
        panel.add(new JLabel("Total Used Memory"), gbc);
        gbc.gridy++;
        panel.add(new JLabel("Max Memory"), gbc);

        gbc.gridy = 0;
        gbc.gridx = 1;
        freeMemory = new JLabel("xxx");
        panel.add(freeMemory, gbc);
        gbc.gridy++;
        usedMemory = new JLabel("xxx");
        panel.add(usedMemory, gbc);
        gbc.gridy++;
        maxMemory = new JLabel("xxx");
        panel.add(maxMemory, gbc);
        gbc.gridy++;

        return panel;
    }

    public void updateLabels() {
        Runtime runtime = Runtime.getRuntime();

        freeMemory.setText(runtime.freeMemory()/MBYTE+" mb");
        usedMemory.setText(runtime.totalMemory()/MBYTE+" mb");
        maxMemory.setText(runtime.maxMemory()/MBYTE+" mb");
    }

    JPanel gui = null;
    JLabel freeMemory;
    JLabel usedMemory;
    JLabel maxMemory;

    static long MBYTE = 1085764;

}

