package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * MapToDisplayTask.java
 *
 * @author Created by Philip Oliver-Paull
 */
public class MapToRealtimeTask implements Task{

    private TaskAction rtSeisDispTaskAction;
    private RTSeismogramDisplayTask rtSeisDispTask;
    private ChannelChooserTask channelChooserTask;

    /**
     * Configures a <code>Task</code> with any needed parameters. The Task
     * should have default values for as many things as possible, but can
     * throw a ConfigureException if a required parameter is missing.
     *
     * @param params a <code>Map</code> value
     * @exception ConfigurationException if an error occurs
     */
    public void configure(Map params) throws ConfigurationException {
        String taskId;
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        TaskAction taskAction;

        taskId = (String)params.get("RTSeisDispTask");
        rtSeisDispTaskAction = commonAccess.getTaskAction(taskId);
        rtSeisDispTask = (RTSeismogramDisplayTask)rtSeisDispTaskAction.getTask();

        taskId = (String)params.get("channelChooserTask");
        taskAction = commonAccess.getTaskAction(taskId);
        channelChooserTask = (ChannelChooserTask)taskAction.getTask();
    }

    /**
     * Called when a task is to be executed, usually by a menu or toolbar
     * selection for simple tasks.
     *
     *
     * @exception Exception if an error occurs
     */
    public void invoke() throws Exception {
        rtSeisDispTask.addChannels(channelChooserTask.getChannelChooser().getSelectedChannels());
        rtSeisDispTaskAction.checkDisplayLocation();
        //channelChooserTask.getChannelChooser().clearStationSelection();
    }

    /**
     * Called when reset is invoked on gee or if this task is no longer being used
     *
     */
    public void destroy() {}

}


