package edu.sc.seis.gee.task;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.DefaultParamNames;

/**
 * HtmlViewerTask.java
 *
 *
 * Created: Fri Feb  1 08:31:17 2002
 *
 * @author <a href="mailto:">Srinivasa Telukutla</a>
 * @version
 */

public class HtmlViewerTask  implements GUITask {
    public void invoke() {
    }


    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
    }

    public void destroy(){}


    /** Gets the "More Options" GUI component.
     */
    public JComponent getMoreOptionsGUI() {
        // TODO
        return null;
    }

    /** Gets the GUI for this Task. Used for interacting with the user
     before and after invoking this Task's action.
     */
    public JComponent getGUI() throws Exception {
        if (editorPane == null) {
            initializeGUI();
        }
        return new JScrollPane(editorPane);
    }

    /** True if this GUI has a "more options" funtionality. More options
     *  appear in a separate panel below the main gui, and can be shown/hidden
     *  with a "Show More Options" and "Hide More Options" button that is
     *  provided automatically is this return true.
     */
    public boolean hasMoreOptions() {
        // TODO
        return false;
    }

    public void initializeGUI() throws MalformedURLException, IOException {
        editorPane = new JEditorPane();
        editorPane.setEditable(false);

        comboBox = new JComboBox();
        comboBox.setEditable(false);
        TaskAction taskAction = (TaskAction)configParams.get(DefaultParamNames.TASK_ACTION);
        taskAction.addToToolBar(comboBox);
        populateURLField(comboBox);

        editorPane.addHyperlinkListener(new HyperlinkListener() {

                    public void hyperlinkUpdate(HyperlinkEvent hle) {
                        if(  hle.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            URL link = hle.getURL();
                        }
                    }
                });

        comboBox.addActionListener(new ActionListener() {

                    public void actionPerformed(ActionEvent e) {
                        String filename = (String) comboBox.getSelectedItem();
                        if(urlMap.containsKey(filename)) {
                            try {
                                editorPane.setPage((URL)urlMap.get(filename));
                            } catch (IOException ex) {
                                GlobalExceptionHandler.handle("Trouble loading "+filename+", "+
                                                                 (String)urlMap.get(filename), ex);
                            }
                        }
                    }
                });
        String filename = (String)comboBox.getItemAt(comboBox.getSelectedIndex());
        editorPane.setPage((URL)urlMap.get(filename));
    }

    private void populateURLField(JComboBox comboBox) throws MalformedURLException {
        Iterator iter = configParams.keySet().iterator();
        while(iter.hasNext()) {
            String key = (String) iter.next();
            if(key.startsWith("URL_")) {
                comboBox.addItem(key.substring(4));
                urlMap.put(key.substring(4), new URL((String)configParams.get(key)));
            } else if( key.startsWith("jar_")) {
                comboBox.addItem(key.substring(4));
                URL resource = getClass().getClassLoader().getResource((String)configParams.get(key));
                urlMap.put(key.substring(4), resource);
            }
        }
    }

    private java.util.Map configParams;

    private java.util.Map urlMap = new java.util.HashMap();

    private JEditorPane editorPane = null;

    private JComboBox comboBox;

}// HtmlViewerTask

