package edu.sc.seis.gee.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseForwarder;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseListener;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseMotionForwarder;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseMotionListener;

/**
 * GlobalToolBarTask.java
 *
 *
 * Created: Wed Jun 26 14:51:53 2002
 *
 * @author <a href="mailto:">Charlie Groves</a>
 * @version
 */

public class GlobalToolBar{
    public static void add(SDMouseListener listener) {
        mouseForwarder.add(listener);
    }

    public static void remove(SDMouseListener listener){
        mouseForwarder.remove(listener);
    }

    public static void add(SDMouseMotionListener listener){
        motionForwarder.add(listener);
    }

    public static void remove(SDMouseMotionListener listener){
        motionForwarder.remove(listener);
    }

    public static void add(SDMouseAdapter adapter){
        motionForwarder.add(adapter);
        mouseForwarder.add(adapter);
    }

    public static void remove(SDMouseAdapter adapter){
        motionForwarder.remove(adapter);
        mouseForwarder.remove(adapter);
    }

    public synchronized static void setActive(SDMouseAdapter adapter){
        setActive((SDMouseListener)adapter);
        setActive((SDMouseMotionListener)adapter);
    }

    public synchronized static void setActive(SDMouseListener listen){
        clearActiveMouseListener();
        mouseForwarder.add(listen);
        activeMouse = listen;
        changed();
    }

    public synchronized static void clearActiveMouseListener(){
        if(activeMouse != null) mouseForwarder.remove(activeMouse);
        activeMouse = null;
    }

    public synchronized static void setActive(SDMouseMotionListener listen){
        clearActiveMouseMotionListener();
        motionForwarder.add(listen);
        activeMotion = listen;
        changed();
    }

    public synchronized static void clearActiveMouseMotionListener(){
        if(activeMotion != null)motionForwarder.remove(activeMotion);
        activeMotion = null;
    }



    public static void add(GlobalToolBarListener listener){
        listeners.add(listener);
    }

    public static void remove(GlobalToolBarListener listener){
        listeners.remove(listener);
    }

    private static void changed(){
        synchronized(listeners){
            Iterator it = listeners.iterator();
            while(it.hasNext()){
                ((GlobalToolBarListener)it.next()).globalToolBarChanged();
            }
        }
    }

    public static SDMouseForwarder getMouseForwarder(){ return mouseForwarder; }

    public static SDMouseMotionForwarder getMouseMotionForwarder(){ return motionForwarder; }

    private static SDMouseForwarder mouseForwarder = new SDMouseForwarder();

    private static SDMouseMotionForwarder motionForwarder = new SDMouseMotionForwarder();

    private static SDMouseListener activeMouse;

    private static SDMouseMotionListener activeMotion;

    private static List listeners = Collections.synchronizedList(new ArrayList());
}// GlobalToolBar
