/**
 * Implemented by Tasks that have a GUI that can be shown. In general the
 * getGUI method should be used for providing information to the user and
 * getting configuration options while the invoke method should do something.
 *
 * @author Philip Crotwell
 */

package edu.sc.seis.gee.task;

import javax.swing.JComponent;

public interface GUITask extends Task {

    /** Gets the GUI for this Task. Used for interacting with the user
    before and after invoking this Task's action.
     */
    JComponent getGUI() throws Exception;

    /** True if this GUI has a "more options" funtionality. More options
     *  appear in a separate panel below the main gui, and can be shown/hidden
     *  with a "Show More Options" and "Hide More Options" button that is
     *  provided automatically is this return true.
     */
    boolean hasMoreOptions();

    /** Gets the "More Options" GUI component.
     */
    JComponent getMoreOptionsGUI();

}

