package edu.sc.seis.gee.task;

import java.util.Map;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;

public abstract class DisplayMakerTask implements Task {

    public abstract SeismogramDisplay makeDisplay();

    public abstract boolean needsEventInformation();

    public void invoke() throws ConfigurationException {
        if(colSeis == null) {
            CommonAccess ca = CommonAccess.getCommonAccess();
            TaskAction ta = ca.getTaskAction(colSeisId);
            colSeis = (ColumnSeismogramTask)ta.getTask();
        }
        colSeis.setDisplayMaker(this);
    }

    public void configure(Map configParams) {
        this.params = configParams;
        if(configParams.containsKey("colSeisTarget")) {
            colSeisId = (String)configParams.get("colSeisTarget");
        }
    }

    public void destroy() {}

    private String colSeisId;

    protected ColumnSeismogramTask colSeis;

    protected Map params;
}