package edu.sc.seis.gee.task;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.swing.JOptionPane;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.Start;
import edu.sc.seis.gee.configurator.ConfigurationException;

/**
 * @author groves Created on Nov 29, 2004
 */
public class ConfigSwitchTask implements Task {

    public void configure(Map params) throws ConfigurationException {
        configFile = (String)params.get("configFile");
        if(configFile == null) { throw new ConfigurationException("ConfigSwitchTask must have a configFile element"); }
    }

    public void invoke() throws Exception {
        switchConfig(configFile);
    }

    public void switchConfig(String newConfigFile) throws IOException,
            ConfigurationException {
        if(!NetworkGateKeeper.accessAllowed()
                && ((newConfigFile.startsWith("http:")) || (newConfigFile.startsWith("ftp:")))) {
            JOptionPane.showMessageDialog(FrameManager.getManager()
                                                  .getCurrentFrame(),
                                          "This feature needs an Internet Connection. Please check your connection"
                                                  + " and restart GEE",
                                          "Warning",
                                          JOptionPane.WARNING_MESSAGE);
        } else {
            switchConfig(Start.getReader(newConfigFile));
        }
    }

    public void switchConfig(Reader newConfig) throws ConfigurationException {
        CommonAccess common = CommonAccess.getCommonAccess();
        common.getConfigure().load(newConfig);
        common.resetActivity();
    }

    private String configFile;

    public void destroy() {}
}