package edu.sc.seis.gee.task;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CheckListBox extends JFrame{
    public CheckListBox ( String[] values,String title){
		super(title);
		panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		this.getContentPane().add(panel);
		initGUI(values);
		this.setSize(400,300);
    }
	private void initGUI(String[] values) {
		JButton closeButton = new JButton("Close Window");
		JButton selectAllButton = new JButton("Select All");
		JPanel toolPanel = new JPanel();
		toolPanel.setLayout(new FlowLayout());
		toolPanel.add(closeButton);
		toolPanel.add(selectAllButton);
		
		closeButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent ae) {
						closeDialog();
					}
				});
		
		selectAllButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent event) {
						selectAll();
					}
				});
		for(int i=0;i<values.length;i++) {
			addItem(values[i]);
		}
		JScrollPane scrollPane = new JScrollPane(panel,JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		this.getContentPane().add(scrollPane,BorderLayout.CENTER);
		this.getContentPane().add(toolPanel,BorderLayout.SOUTH);
		this.setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
	}
	
	public void addItem(String element) {
		if(!Exists(element)) {
			JCheckBox checkBox = new JCheckBox(element);
			checkBoxList.add(checkBox);
			panel.add(checkBox);
		}
	}
	
	private boolean Exists(String inputString) {
		Iterator iter = checkBoxList.iterator();
		while(iter.hasNext()) {
			String nodeText = ((JCheckBox)iter.next()).getText();
			if(inputString.equals(nodeText)) {
				return true;
			}
		}
		return false;
	}
	
	private void closeDialog() {
		this.hide();
	}
	
	public String[] getSelectedValues() {
        List selectedValues = new ArrayList();
		Iterator iter = checkBoxList.iterator();
		while(iter.hasNext()) {
			JCheckBox checkBox = (JCheckBox) iter.next();
			if(checkBox.isSelected()){
				selectedValues.add(checkBox.getText());
			}
		}
		return (String[])selectedValues.toArray(new String[0]);
	}
    
	public void selectAll() {
		Iterator iter = checkBoxList.iterator();
		while(iter.hasNext()) {
			JCheckBox checkBox = (JCheckBox) iter.next();
			checkBox.setSelected(true);
		}
	}
	
	public static void main(String[] args) {
		String[] values = {"hello","me","helloby","a","b","c","d","e","this"};
		CheckListBox checkList = new CheckListBox(values,"CheckListBox");
		checkList.setVisible(true);
		checkList.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
	private JPanel panel;
	private List checkBoxList = new ArrayList();
}


