package edu.sc.seis.gee.configurator;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;

/**
 * Handles the XML elements within a Task tag. Created: Wed Nov 28 16:15:04 2001
 * 
 * @author <a href="mailto:">Philip Crotwell </a>
 * @version $Id: TaskHandler.java 11395 2004-12-07 22:29:20Z oliverpa $
 */
public class TaskHandler extends AbstractHandler implements DefaultParamNames {

    public TaskHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
        super(parser, parent);
        configParam.put(DISPLAY_LOCATION, FRAME);
    }

    public void startElement(String namespaceURI,
                             String localName,
                             String qName,
                             Attributes atts) {
        if(localName.equals("id")) {
            parser.setContentHandler(new TaskHandler.IdHandler(parser, this));
        } else if(localName.equals("class")) {
            parser.setContentHandler(new TaskHandler.ClassNameHandler(parser,
                                                                      this));
        } else if(localName.equals("name")) {
            parser.setContentHandler(new TaskHandler.NameHandler(parser, this));
        } else if(localName.equals("taskconfig")) {
            parser.setContentHandler(new TaskConfigHandler(parser,
                                                           this,
                                                           classname,
                                                           getTaskInstance()));
        } else if(localName.equals("tooltip")) {
            parser.setContentHandler(new ToolTipHandler(parser, this));
        } else if(localName.equals("toggle")) {
            toggle = true;
            parser.setContentHandler(new ToggleHandler(parser, this));
        } else if(localName.equals("icon")) {
            parser.setContentHandler(new IconHandler(parser, this));
        } else if(localName.equals("toolbar")) {
            toolbar = new ToolBarHandler(parser, this);
            parser.setContentHandler(toolbar);
        } else {
            logger.warn("TaskHandler unknown tag: " + localName);
        } // end of else
    }

    protected void finished() {
        configParam.put(TASK_NAME, name);
        configParam.put(TASK_ID, id);
        configParam.put(TASK_CLASSNAME, classname);
        if(tooltip.length() != 0) {
            configParam.put(TOOLTIP, makeHTML(tooltip, 50));
        } // end of if (tooltip.length() != 0)
    }

    public TaskAction getTaskAction() throws ConfigurationException {
        if(iconName != null && !iconName.equals("")) { return new TaskAction(id,
                                                                             classname,
                                                                             name,
                                                                             configParam,
                                                                             toolbar,
                                                                             toggle,
                                                                             iconName); }
        return new TaskAction(id, classname, name, configParam, toolbar, toggle);
    }

    public void addConfigParam(String configName, Object value) {
        configParam.put(configName, value);
    }

    String makeHTML(String text, int maxCol) {
        String html = "<html><body>";
        int index = 0;
        while(index < text.length()) {
            int nextSpace = text.indexOf(' ', index + maxCol);
            if(nextSpace == -1) {
                break;
            } // end of if (nextSpace == -1)
            html += text.substring(index, nextSpace);
            html += "<p>";
            index = nextSpace + 1;
        } // end of while (index < text.length)
        html += text.substring(index);
        html += "</body></html>";
        return html;
    }

    void setTaskInstance(Task task) {
        this.task = task;
        addConfigParam(TASK_INSTANCE, getTaskInstance());
    }

    Task getTaskInstance() {
        if(task == null){
            task = AllTasks.getTask(id);
        }
        return task;
    }

    String id = "";

    String name = "";

    String classname = "";

    String iconName = "";

    HashMap configParam = new HashMap();

    ToolBarHandler toolbar;

    boolean toggle = false;

    boolean toggleSet = false;

    String tooltip = "";

    Task task = null;

    class IdHandler extends AbstractHandler {

        IdHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            id += new String(ch, start, length);
        }
    }

    class NameHandler extends AbstractHandler {

        NameHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            name += new String(ch, start, length);
        }
    }

    class ToolTipHandler extends AbstractHandler {

        ToolTipHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            tooltip += new String(ch, start, length);
        }
    }

    class ClassNameHandler extends AbstractHandler {

        ClassNameHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            classname += new String(ch, start, length);
        }
    }

    class ToggleHandler extends AbstractHandler {

        ToggleHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }
    }

    class IconHandler extends AbstractHandler {

        IconHandler(org.xml.sax.XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            iconName += new String(ch, start, length);
        }
    }

    static Logger logger = Logger.getLogger(TaskHandler.class);
}// TaskHandler
