package edu.sc.seis.gee.configurator;


import org.apache.log4j.Category;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SimpleErrorHandler implements ErrorHandler {

    //not sure why this is needed???
    boolean warmup=false;

            /** Warning. */
    public void warning(SAXParseException ex) throws SAXException {
    logger.warn(getLocationString(ex), ex);
    }

    /** Error. */
    public void error(SAXParseException ex)  throws SAXException {
        if (warmup)
            return;

    logger.error(getLocationString(ex), ex);
        throw ex;
    }

    /** Fatal error. */
    public void fatalError(SAXParseException ex) throws SAXException {
        if (warmup)
            return;

        logger.fatal(getLocationString(ex), ex);
        throw ex;
    }

    /** Returns a string of the location. */
    public static String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();

        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf('/');
            if (index != -1)
                systemId = systemId.substring(index + 1);
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());

        return str.toString();

    } // getLocationString(SAXParseException):String

    static Category logger = Category.getInstance(SimpleErrorHandler.class.getName());
 }
