package edu.sc.seis.gee.configurator;

import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.ButtonGroupManager;
import edu.sc.seis.gee.task.TaskAction;

/**
 * MenuitemHandler.java
 *
 *
 * Created: Wed Nov 28 16:15:04 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version $Id: MenuItemHandler.java 11395 2004-12-07 22:29:20Z oliverpa $
 */

public class MenuItemHandler extends AbstractHandler {
    public MenuItemHandler (org.xml.sax.XMLReader parser,
                            AbstractHandler parent){
        super(parser, parent);
    }

    public void startElement(String namespaceURI,
                             String localName,
                             String qName,
                             Attributes atts) {
        if (localName.equals("taskid")) {
            parser.setContentHandler(new MenuItemHandler.TaskIdHandler(parser,
                                                                       this));
        }

    }

    public JMenuItem getMenuItem() throws ConfigurationException {
        if (taskid.length() != 0 && AllTasks.getTaskAction(taskid) != null) {
            final TaskAction task = AllTasks.getTaskAction(taskid);
            JMenuItem menu;
            if (task.isToggle()) {
                if (task.getConfigParam(DefaultParamNames.BUTTON_GROUP_ID) != null) {
                    menu =
                        new JRadioButtonMenuItem(task);
                    ButtonGroup bg =
                        ButtonGroupManager.get((String)task.getConfigParam(DefaultParamNames.BUTTON_GROUP_ID));
                    bg.add(menu);
                    if (task.getConfigParam(DefaultParamNames.BUTTON_MODEL) != null) {
                        menu.setModel((ButtonModel)task.getConfigParam(DefaultParamNames.BUTTON_MODEL));
                    } else {
                        task.putConfigParam(DefaultParamNames.BUTTON_MODEL, menu.getModel());
                    }
                } else {
                    menu = new JCheckBoxMenuItem(task);
                    if(task.getConfigParam(DefaultParamNames.PRESELECTED) != null &&
                       task.getConfigParam(DefaultParamNames.PRESELECTED).equals(DefaultParamNames.TRUE)){
                        ((JCheckBoxMenuItem)menu).setSelected(true);
                    }else{
                        ((JCheckBoxMenuItem)menu).setSelected(false);
                    }
                } // end of else

                menu.setActionCommand(task.getId());
            } else {
                menu =  new JMenuItem(AllTasks.getTaskAction(taskid));
            } // end of else
            return menu;
        } // end of if (taskid.length() != 0)
        logger.error("Can't find task "+taskid);
        JMenuItem noTask = new JMenuItem(taskid+" unavailable");
        noTask.setEnabled(false);
        return noTask;
    }

    String taskid = "";

    class TaskIdHandler extends AbstractHandler {
        TaskIdHandler(org.xml.sax.XMLReader parser,
                      AbstractHandler parent){
            super(parser, parent);
        }

        public void characters(char[] ch,
                               int start,
                               int length)
            throws SAXException {
            taskid +=  new String(ch, start, length);
        }
    }

    static org.apache.log4j.Category logger = org.apache.log4j.Category.getInstance(MenuItemHandler.class.getName());

}
