package edu.sc.seis.gee.configurator;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * MenuHandler.java
 *
 *
 * Created: Wed Nov 28 16:15:04 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version $Id: MenuHandler.java 10257 2004-08-31 13:47:25Z groves $
 */

public class MenuHandler extends AbstractHandler implements ToolBarItem {
    public MenuHandler (org.xml.sax.XMLReader parser,
                AbstractHandler parent){
    super(parser, parent);
    }

    public void startElement(String namespaceURI,
                 String localName,
                 String qName,
                 Attributes atts) {
    if (localName.equals("name")) {
        parser.setContentHandler(new MenuHandler.NameHandler(parser,
                                 this));
    } else if (localName.equals("menuItem")) {
        MenuItemHandler handler = new MenuItemHandler(parser, this);
        parser.setContentHandler(handler);
        menuItem.add(handler);
    } else if (localName.equals("menu")) {
        MenuHandler handler = new MenuHandler(parser,
                          this);
        parser.setContentHandler(handler);
        menuItem.add(handler);
    } else if (localName.equals("separator")) {
        SeparatorHandler handler = new SeparatorHandler(parser,
                                this);
        parser.setContentHandler(handler);
        menuItem.add(handler);
    }

    }

    public JMenu getMenu()  throws ConfigurationException {
    JMenu menu = new JMenu(name);
    Iterator it = menuItem.iterator();
    while (it.hasNext()) {
        Object item = it.next();
        if (item instanceof MenuHandler) {
        MenuHandler mh = (MenuHandler)item;
        menu.add(mh.getMenu());
        } else if (item instanceof SeparatorHandler) {
        menu.addSeparator();
        } else {
        MenuItemHandler mih = (MenuItemHandler)item;
        menu.add(mih.getMenuItem());
        } // end of else
    }
    return menu;
    }

    public JPopupMenu getPopupMenu() throws ConfigurationException {

        JPopupMenu menu = new JPopupMenu(name);
        Iterator it = menuItem.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof MenuHandler) {
                MenuHandler mh = (MenuHandler)item;
                menu.add(mh.getMenu());
            } else if (item instanceof SeparatorHandler) {
                menu.addSeparator();
            } else {
                MenuItemHandler mih = (MenuItemHandler)item;
                menu.add(mih.getMenuItem());
            } // end of else
        }
        return menu;
    }

    public String getName() {
        return name;
    }

    String name = "";
    LinkedList menuItem = new LinkedList();

    class NameHandler extends AbstractHandler {
    NameHandler(org.xml.sax.XMLReader parser,
             AbstractHandler parent){
        super(parser, parent);
    }

    public void characters(char[] ch,
                   int start,
                   int length)
        throws SAXException {
        name +=  new String(ch, start, length);
    }
    }

    class SeparatorHandler extends AbstractHandler {
    SeparatorHandler(org.xml.sax.XMLReader parser,
             AbstractHandler parent){
        super(parser, parent);
    }
    }
}

