package edu.sc.seis.gee.configurator;

import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenuBar;
import org.xml.sax.Attributes;

/**
 * MenubarHandler.java
 *
 *
 * Created: Wed Nov 28 16:15:04 2001
 *
 * @author <a href="mailto:">Philip Crotwell</a>
 * @version $Id: MenuBarHandler.java 10257 2004-08-31 13:47:25Z groves $
 */

public class MenuBarHandler extends AbstractHandler {
    public MenuBarHandler (org.xml.sax.XMLReader parser,
                AbstractHandler parent){
    super(parser, parent);
    }

    public void startElement(String namespaceURI,
                 String localName,
                 String qName,
                 Attributes atts) {
    if (localName.equals("menu")) {
        MenuHandler handler = new MenuHandler(parser,
                          this);
        parser.setContentHandler(handler);
        menus.add(handler);
    }

    }

    public JMenuBar getMenuBar()  throws ConfigurationException {
        JMenuBar menubarCache = new JMenuBar();
        Iterator it = menus.iterator();
        while (it.hasNext()) {
            MenuHandler mh = (MenuHandler)it.next();
            menubarCache.add(mh.getMenu());
        }
        return menubarCache;
    }

    LinkedList menus = new LinkedList();

}
