package edu.sc.seis.gee.configurator;

/**
 * DefaultParamNames.java
 *
 *
 * Created: Wed Jan 15 11:55:11 2003
 *
 * @author <a href="mailto:crotwell@owl.seis.sc.edu">Philip Crotwell</a>
 * @version 1.0
 */
public interface DefaultParamNames {

    public static final String PREFIX = "gee.task.";

    /** Referes to the name of a task, which would be shown in a menu*/
    public static final String TASK_NAME = PREFIX+"name";

    /** Refers to the id of a task, which tasks can use to find other tasks. */
    public static final String TASK_ID = PREFIX+"id";

    /** The name of the java class of the given task.*/
    public static final String TASK_CLASSNAME = PREFIX+"classname";

    /** An instance of the java class of the given task, may not always be
     *  needed.*/
    public static final String TASK_INSTANCE = PREFIX+"task";

    /** The tooltip to be displayed from a menu or tool pallete.*/
    public static final String TOOLTIP = PREFIX+"tooltip";

    /** The id of the button group that this belongs, used to implement radio
     *  style buttons. */
    public static final String BUTTON_GROUP_ID = PREFIX+"buttonGroupId";

    /** The id of the button group that this belongs, used to implement radio
     *  style buttons. */
    public static final String BUTTON_MODEL = PREFIX+"buttonModel";

    /** The TaskAction object that holds and manages this task. This is
     *  automatically added by the task creation system, and should never
     *  appear in a configuration file. */
    public static final String TASK_ACTION = PREFIX+"taskAction";

    /** The display location for this task. Currently this can be one of
     *  main, frame, pallette or none. */
    public static final String DISPLAY_LOCATION = PREFIX+"displayLocation";

    /** The task wishes to occupy the main application window. */
    public static final String MAIN = "main";

    /** The task wishes to have a frame of its own. */
    public static final String FRAME = "frame";

    /** The task wish to be displayed as a floating tool pallette. */
    public static final String PALETTE = "palette";

    /** The task does not have a GUI, and will not need any display area. */
    public static final String NONE = "none";

    /** The minimum width for the tasks display in pixels. */
    public static final String WIDTH = PREFIX+"width";

    /** The preferred percentage width of the screen for the task */
    public static final String WIDTHPER = PREFIX + "widthpercentage";

    /** The minimum height for the tasks display in pixels. */
    public static final String HEIGHT = PREFIX+"height";

    /** The preferred percentage height of the screen for the task */
    public static final String HEIGHTPER = PREFIX + "heightpercentage";

    /** The jusitification for a task's frame within the desktop. This is
     *  useful so that new tasks do not obscure previously displayed tasks.
     */
    public static final String JUSTIFY = PREFIX+"justify";

    /** Put the frame in the middle of the screen. */
    public static final String JUSTIFY_CENTER = "center";

    /** Put the frame in the top left corner. */
    public static final String JUSTIFY_TOPLEFT = "topleft";

    /** Put the frame in the top right corner. */
    public static final String JUSTIFY_TOPRIGHT = "topright";

    /** Put the frame in the bottom left corner. */
    public static final String JUSTIFY_BOTTOMLEFT = "bottomleft";

    /** Put the frame in the bottom right corner. */
    public static final String JUSTIFY_BOTTOMRIGHT = "bottomright";

    /** Used for a boolean configuration value. */
    public static final String TRUE = "true";

    /** Used for a boolean configuration value. */
    public static final String FALSE = "false";

    /** The reversed DNS path through the naming service heirarchy. Used
     *  for connecting to a CORBA server that uses the fisures naming
     *  service conventions. */
    public static final String SERVER_DNS = "serverDNS";

    /** The Name Service name for a server. Used for connecting to a
     *  CORBA server that uses the fisures naming service conventions. */
    public static final String SERVER_NAME = "serverName";

    public static final String ORIENTATION = "orientation";

    /** Signifies data with north-south orientation should be used */
    public static final String NORTH = ORIENTATION + ".north";

    /** Signifies data with east-west orientation should be used */
    public static final String EAST = ORIENTATION + ".east";

    /** Signifies data with vertical orientation should be used */
    public static final String VERTICAL = ORIENTATION + ".vertical";

    /** Signifies data with horizontal orientation should be used */
    public static final String HORIZONTAL = ORIENTATION + ".horizontal";

    /** Signifies that a task is preselected. For example if it is places in
     a menu as a JCheckBoxMenuItem, it should be checked at program startup. */
    public static final String PRESELECTED = PREFIX+"preselected";

} // DefaultParamNames
