package edu.sc.seis.gee.configurator;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import edu.sc.seis.fissuresUtil.xml.XMLDataSet;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.gee.Start;

/**
 * @author groves Created on Nov 29, 2004
 */
public class Configuration {

    public Configuration(Element configEl) {
        this(extractLocations(configEl),
             extractLocationNames(configEl),
             extractName(configEl),
             extractDescription(configEl),
             extractImage(configEl));
    }

    public Configuration(String[] locations, String[] locationNames,
            String name, String description, String image) {
        this.name = name;
        this.description = description;
        this.image = image;
        this.configs = locations;
        this.names = locationNames;
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public int getNumConfigs() {
        return configs.length;
    }

    public String getName(int i) {
        return names[i];
    }

    public String getConfig(int i) {
        return configs[i];
    }

    public String getImage() {
        return image;
    }

    private String name, description, image;

    private String[] configs, names;

    public static Configuration[] loadConfigs(String configsFileLoc)
            throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = XMLDataSet.getDocumentBuilder();
        Document doc = docBuilder.parse(new InputSource(Start.getReader(configsFileLoc)));
        Element docElement = doc.getDocumentElement();
        NodeList configEls = docElement.getElementsByTagName("group");
        Configuration[] configs = new Configuration[configEls.getLength()];
        for(int i = 0; i < configEls.getLength(); i++) {
            configs[i] = new Configuration((Element)configEls.item(i));
        }
        return configs;
    }

    private static String extractDescription(Element configEl) {
        return getTextInElement(configEl, "description");
    }

    private static String extractName(Element configEl) {
        return getTextInElement(configEl, "name");
    }

    private static String[] extractLocations(Element configEl) {
        return extractFromConfigs(configEl, "location");
    }

    private static String[] extractLocationNames(Element configEl) {
        return extractFromConfigs(configEl, "name");
    }

    private static String[] extractFromConfigs(Element mainEl, String tagName) {
        NodeList nl = mainEl.getElementsByTagName("config");
        String[] strings = new String[nl.getLength()];
        for(int i = 0; i < nl.getLength(); i++) {
            Element config = (Element)nl.item(i);
            strings[i] = getTextInElement(config, tagName);
        }
        return strings;
    }

    private static String extractImage(Element configEl) {
        return getTextInElement(configEl, "image");
    }

    private static String getTextInElement(Element el, String textElName) {
        return XMLUtil.getText(XMLUtil.getElement(el, textElName));
    }
}