/**
 * NoNetworkException.java
 *
 * @author Created by Omnicore CodeGuide
 */

package edu.sc.seis.gee;

import javax.swing.JOptionPane;

public class NoNetworkException extends Exception {

    public NoNetworkException() {
        super(noNetworkMessage);
    }

    public NoNetworkException(String message) {
        super(message);
    }

    public void showMessage() {
        JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(),
                                      getMessage(),
                                      "No Network Available",
                                      JOptionPane.ERROR_MESSAGE);
    }

    public static final String noNetworkMessage =
        "GEE is unable to get a network connection at this time.";
}

