from gee.test.Jytest import Jytest
from gee.display import Frame, TabbedPanel, Toolbar
from javax.swing import JPanel, JButton, JLabel

class FrameTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)
        Frame.visibleIfContentGiven = False
        
    def test_creation(self):
        panel = JPanel()
        win = Frame(content=panel)
        assert win.content == panel
        
class TabbedPanelTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)
        self.labels = [JLabel('First'), JLabel('Second')]
        
    def test_creation(self):
        tab = TabbedPanel(self.labels)
        assert self.labels[0] == tab[0]
        assert self.labels[1] == tab[1]

    def test_remove(self):
        tab = TabbedPanel(self.labels)
        del tab[1]
        assert len(tab) == 1
        assert not self.labels[1] in tab
        assert self.labels[0] in tab
        tab.remove(self.labels[0])
        assert len(tab) == 0
        for label in self.labels: assert not label in tab
        for label in self.labels: tab.add(label)
        assert len(tab) == 2
        for label in self.labels: assert label in tab
        
    def test_add(self):
        tab = TabbedPanel()
        for label in self.labels: tab.add(label)
        assert len(tab) == 2
        for label in self.labels: assert label in tab
        
        
class ToolbarTest(Jytest):
    def __init__(self, name): 
        Jytest.__init__(self, name)
        
    def setUp(self):
        self.buttons = [JButton('HOWDY'), JButton('BOY HOWDY')]
        self.groupname = 'greetings'
        
    def test_creation(self):
        toolbar = Toolbar(self.buttons, self.groupname)
        assert len(toolbar) == 2
        for i, button in enumerate(self.buttons):
            assert button in toolbar[self.groupname]
        assert toolbar[-1] == self.buttons[-1]
        
    def test_three_groups(self):
        toolbar = Toolbar(self.buttons[0], self.groupname)
        secondGroupName = 'exuberantGreetings'
        toolbar.add(self.buttons[1], secondGroupName)
        lastButton = JButton('BOY HOWDY!  YEEHA!')
        lastGroup = 'manicallyExuberantGreetings'
        toolbar.add(lastButton, lastGroup)
        assert len(toolbar) == 5
        assert len(toolbar.groups) == 3
        assert self.buttons[0] in toolbar[self.groupname]
        assert self.buttons[0] == toolbar[0]
        assert self.buttons[1] in toolbar[secondGroupName]
        assert self.buttons[1] == toolbar[-3]
        assert lastButton in toolbar[lastGroup]
        assert lastButton == toolbar[-1]
        