class PickSwitcher(Receiver):
    def __init__(self, seismograms, display):
        self.seismograms = seismograms
        self.disp = display
    
    def receive(self, pick):
        SacWriter(seis.name + '.sac', self.disp.seis[0])
        self.disp.notify()
        
class BarGraphLabels(Receiver):
    self.ratrs = []
    
    def __init__(self, graph, disp):
        self.graph = graph
        self.disp = disp
        
    def receive(self, pick):
        self.ratrs.append(pick.displ.arrivals['ttp'].time - pick.subject.time)
        self.ratrs.sort()
        self.graph.setLabel("""N = %s
Mean = %s
Med. = %s
S.D. = %s""" % (len(ratrs), mean(ratrs), median(ratrs), sd(ratrs))
        graph.receive(Message(ratrs[-1]))
    
seismograms = SeisReader('seis'):#if given a directory, recurses and loads all seis
for station, stationSeis in StationGrouper(seismograms):
    win = Window(station.name)
    os.mkdir(station.name)
    os.chdir(station.name)
    display = SeisDisplay()
    toolbar = SeisDisplayToolbar(display)
    pt = PickTool(display, pick='ttp')
    toolbar.add(pt)
    pt.addReceiver(PickSwitcher(stationSeis, display))
    bar = BarGraph(title=station.name,
                   xTitle='Relative Arrival-Time Residual(s)',
                   yTitle='Total Number of Events',
                   xRange=(-2,2),
                   yRange=(0,35))


    for seis in stationSeis:
        display.add(seis)
        display.wait()
        display.remove(seis)
    os.chdir('..')