from gee.event import EventServer, EventDB, EventQuery, EventTable, EventList
from gee.net import NetServer, NetDB, NetQuery, StationTable, StationList

irisEventServer = EventServer('edu/iris/dmc/IRISEventDC')
noteworthyEvents = EventServer('edu/sc/seis/Noteworthy')
eventDb = EventDB(sources=[irisEventServer, noteworthyEvents])
EventQuery(irisEventServer, noteworthEvents, eventDb)

eventTable = EventTable(lists=eventDb)
mainMap = Map(lists=eventDb)
selectedEvents = EventList(lists=[eventTable.selected, mainMap.selected])
selectedEvents.addSinks(eventTable.selected, mainMap.selected)

irisNetServer = NetServer('edu/iris/dmc/IRISNetDC')
netDb = NetDB(sources=[irisNetServer])
NetQuery(irisNetServer, netDb)
available = AvailableStations(selectedEvents, netDb)
stationTable = StationTable(sources=[available])
mainMap.addSources(available)
selectedStations = StationList(sources=[stationTable.selected, mainMap.selected])
selectedStations.addSinks(stationTable.selected, mainMap.selected)

win = Window('GEE')
tab = TabPanel()
win.content = tab
tab.add(mainMap, 'World Map')
win.visible = True


seisLoader = SmartSeisServer(selectedEvents, selectedStations)
dataset = Dataset(sources=seisLoader)
eventSplitter = DistinctEventSplitter(sources=seisLoader)

class EventLabel:
    def __init__(event):
        pass
    
class VisibilityToggler:
    def __init__(self, component):
        self.component = component
    def __call__(self):
        component.visible = not component.visible

def createRecordSection(event):
    seisList = SeismogramList()
    recordSection = RecordSection(sources=seisList)
    recSecMap = Map(sources=[event, seisList.stations, seisList])
    eventInfo = InfoBox(event)
    stationTable = StationTable(sources=seisList.stations)

    mapEqPanel = VBox('Map',
                     recSecMap,
                     'Earthquake Info:',
                     eventInfo)

    toolbar = SeisDisplayToolbar(recordSection)
    toolbar.add(glue)
    toolbar.add(Button("Show/hide map and EQ info"),
                action=VisibilityToggler(mapEqPanel))

    mainBox = VBox(toolbar,
                  HBox(recordSection, mapEqPanel),
                  stationTable)
    tab.add(mainBox, EventLabel(event))

    return seisList

eventSplitter.addSinks(createRecordSection)