/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.winston;

import edu.sc.seis.seisFile.QueryParams;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFileWriter;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import edu.sc.seis.seisFile.winston.WinstonSCNL;
import edu.sc.seis.seisFile.winston.WinstonTable;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinstonUtil {
    Class driverClass = null;
    Connection conn;
    String databaseURL = "jdbc:mysql://localhost/?user=wwsuser&password=";
    String username;
    String password;
    String prefix = "W_";
    String driver = "com.mysql.jdbc.Driver";
    static boolean verbose = true;
    public static final String KEY_PREFIX = "winston.prefix";
    public static final String KEY_DRIVER = "winston.driver";
    public static final String KEY_DBURL = "winston.url";
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String DEFAULT_PREFIX = "W_";
    public static final String DEFAULT_DBURL = "jdbc:mysql://localhost/?user=wwsuser&password=";
    public static final long Y1970_TO_Y2000_SECONDS = 946728000L;
    private static final Logger logger = LoggerFactory.getLogger(WinstonUtil.class);

    public WinstonUtil(Properties winstonConfig) throws SeisFileException, URISyntaxException {
        if (winstonConfig.containsKey(KEY_DBURL)) {
            this.databaseURL = winstonConfig.getProperty(KEY_DBURL);
        }
        this.username = WinstonUtil.getUrlQueryParam("user", this.databaseURL);
        this.password = WinstonUtil.getUrlQueryParam("password", this.databaseURL);
        if (winstonConfig.containsKey(KEY_DRIVER)) {
            this.driver = winstonConfig.getProperty(KEY_DRIVER);
        }
        if (winstonConfig.containsKey(KEY_PREFIX)) {
            this.prefix = winstonConfig.getProperty(KEY_PREFIX);
        }
        logger.debug("Using winston prefix: <" + this.prefix + ">");
    }

    public WinstonUtil(String databaseURL, String username, String password) {
        this(databaseURL, username, password, DEFAULT_PREFIX);
    }

    public WinstonUtil(String databaseURL, String username, String password, String prefix) {
        this(databaseURL, username, password, prefix, MYSQL_DRIVER);
    }

    public WinstonUtil(String databaseURL, String username, String password, String prefix, String driverClassname) {
        this.driver = driverClassname;
        this.databaseURL = databaseURL;
        this.username = username;
        this.password = password;
        this.prefix = prefix;
    }

    public WinstonSCNL createWinstonSCNL(String station, String channel, String network, String locId) {
        return new WinstonSCNL(station, channel, network, locId, this.prefix);
    }

    public WinstonTable createWinstonTable(WinstonSCNL database, int year, int month, int day) {
        return new WinstonTable(database, year, month, day);
    }

    public List<WinstonSCNL> listChannelDatabases() throws SQLException {
        ArrayList<WinstonSCNL> out = new ArrayList<WinstonSCNL>();
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW DATABASES");
        while (rs.next()) {
            String s = rs.getString(1);
            if (s.startsWith(WinstonUtil.prefixTableName(this.getPrefix(), "")) && !s.equalsIgnoreCase(WinstonUtil.prefixTableName(this.getPrefix(), "ROOT"))) {
                out.add(new WinstonSCNL(s, this.getPrefix()));
                continue;
            }
            logger.debug("Skipping, non-prefixed or root db: <" + s + ">");
        }
        rs.close();
        stmt.close();
        conn.commit();
        return out;
    }

    public void useDatabase(WinstonSCNL channel) throws SQLException {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("use `" + channel.getDatabaseName() + "`");
        stmt.close();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WinstonTable> listDayTables(WinstonSCNL channel) throws SQLException {
        ArrayList<WinstonTable> out = new ArrayList<WinstonTable>();
        this.useDatabase(channel);
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SHOW TABLES");
            while (rs.next()) {
                String s = rs.getString(1);
                if (s.contains("$$H") || s.contains("$$h") || s.contains("past2days")) continue;
                try {
                    out.add(new WinstonTable(channel, s));
                }
                catch (ParseException e) {
                    logger.warn("Unable to parse table name: " + s + ", skipping.", (Throwable)e);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            stmt.close();
            conn.commit();
        }
        return out;
    }

    public List<WinstonTable> listTablesBetweenDates(WinstonSCNL channel, int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay) throws SQLException {
        if (startMonth == 0 || endMonth == 0) {
            throw new SQLException("Month cannot be zero, maybe you forgot months are zero based in Calendar?");
        }
        List<WinstonTable> out = this.listDayTables(channel);
        Iterator<WinstonTable> it = out.iterator();
        while (it.hasNext()) {
            WinstonTable wt = it.next();
            if (wt.getYear() < startYear || wt.getYear() > endYear) {
                it.remove();
                continue;
            }
            if (wt.getYear() == startYear && (wt.getMonth() < startMonth || wt.getMonth() == startMonth && wt.getDay() < startDay)) {
                it.remove();
                continue;
            }
            if (wt.getYear() != endYear || wt.getMonth() <= endMonth && (wt.getMonth() != endMonth || wt.getDay() <= endDay)) continue;
            it.remove();
        }
        return out;
    }

    public SyncFile calculateSyncBetweenDates(WinstonSCNL channel, int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay, String dataCenterName) throws SQLException {
        SyncFile out = new SyncFile(dataCenterName);
        List<WinstonTable> tableList = this.listTablesBetweenDates(channel, startYear, startMonth, startDay, endYear, endMonth, endDay);
        if (verbose) {
            System.out.println("Work on tables " + tableList.size());
        }
        for (WinstonTable wt : tableList) {
            if (verbose) {
                System.out.println("Sync for " + wt.getTableName());
            }
            out = out.concatenate(this.calculateSyncForDay(wt));
        }
        return out;
    }

    public void writeSyncBetweenDates(WinstonSCNL channel, int startYear, int startMonth, int startDay, int endYear, int endMonth, int endDay, SyncFileWriter writer) throws SQLException {
        List<WinstonTable> tableList = this.listTablesBetweenDates(channel, startYear, startMonth, startDay, endYear, endMonth, endDay);
        if (verbose) {
            System.out.println("Work on tables " + tableList.size());
        }
        for (WinstonTable wt : tableList) {
            if (verbose) {
                System.out.println("Sync for " + wt.getTableName());
            }
            writer.appendAll(this.calculateSyncForDay(wt), true);
        }
    }

    public SyncFile calculateSyncForDay(WinstonTable table) throws SQLException {
        SyncFile out = new SyncFile("Winston " + table.getTableName());
        this.useDatabase(table.getDatabase());
        SyncLine defaultSyncLine = new SyncLine(table.getDatabase().getNetwork(), table.getDatabase().getStation(), table.getDatabase().getLocId(), table.getDatabase().getChannel());
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setFetchSize(Integer.MIN_VALUE);
        ResultSet rs = stmt.executeQuery("select st, et, sr from " + table.getTableName() + " order by st");
        while (rs.next()) {
            out.addLine(new SyncLine(defaultSyncLine, WinstonUtil.j2KSecondsToDate(rs.getDouble(1)), WinstonUtil.j2KSecondsToDate(rs.getDouble(2)), Float.valueOf(rs.getFloat(3))), true);
        }
        rs.close();
        stmt.close();
        conn.commit();
        return out;
    }

    public List<TraceBuf2> extractData(WinstonSCNL channel, Date startTime, Date endTime) throws SQLException, DataFormatException {
        ArrayList<TraceBuf2> out = new ArrayList<TraceBuf2>();
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).setTimeZone(QueryParams.UTC);
        cal.setTime(startTime);
        int startYear = cal.get(1);
        int startMonth = cal.get(2) + 1;
        int startDay = cal.get(5);
        cal.setTime(endTime);
        int endYear = cal.get(1);
        int endMonth = cal.get(2) + 1;
        int endDay = cal.get(5);
        List<WinstonTable> tableList = this.listTablesBetweenDates(channel, startYear, startMonth, startDay, endYear, endMonth, endDay);
        for (WinstonTable wt : tableList) {
            out.addAll(this.extractData(wt, startTime, endTime));
        }
        return out;
    }

    public List<TraceBuf2> extractData(WinstonTable table, Date startTime, Date endTime) throws SQLException, DataFormatException {
        this.useDatabase(table.getDatabase());
        ArrayList<TraceBuf2> out = new ArrayList<TraceBuf2>();
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setFetchSize(10);
        double y2kStart = WinstonUtil.dateToJ2kSeconds(startTime);
        double y2kEnd = WinstonUtil.dateToJ2kSeconds(endTime);
        String query = "select st, et, tracebuf from `" + table.getTableName() + "` where (" + y2kStart + " <= st AND st <= " + y2kEnd + ") OR (" + y2kStart + " <=et AND et <= " + y2kEnd + ") order by st";
        if (verbose) {
            System.out.println("query: " + query);
        }
        ResultSet rs = stmt.executeQuery(query);
        try {
            while (rs.next()) {
                Blob tbBlob = rs.getBlob("tracebuf");
                byte[] tbBytes = tbBlob.getBytes(1L, (int)tbBlob.length());
                tbBlob.free();
                TraceBuf2 tb = this.extractFromBlob(tbBytes);
                out.add(tb);
                if (!verbose) continue;
                Date stDate = WinstonUtil.j2KSecondsToDate(rs.getDouble("st"));
                Date etDate = WinstonUtil.j2KSecondsToDate(rs.getDouble("et"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                sdf.setTimeZone(QueryParams.UTC);
                System.out.println("db row: " + sdf.format(stDate) + "  (" + WinstonUtil.dateToJ2kSeconds(stDate) + ")  " + sdf.format(etDate) + "  (" + WinstonUtil.dateToJ2kSeconds(etDate) + ")");
                if (Math.abs(stDate.getTime() - tb.getStartDate().getTime()) > 2L) {
                    System.out.println("WARNING, st differs from traceBuf start by more than 2 milliseconds: " + sdf.format(stDate) + "  " + sdf.format(tb.getStartDate()));
                }
                if (Math.abs(etDate.getTime() - tb.getPredictedNextStartDate().getTime()) <= 2L) continue;
                System.out.println("WARNING, et differs from traceBuf end by more than 2 milliseconds: " + sdf.format(etDate) + "  " + sdf.format(tb.getPredictedNextStartDate()));
            }
        }
        catch (DataFormatException e) {
            System.err.println("WARNING: unable to unzip tracebuf, query was: " + query);
            throw e;
        }
        finally {
            rs.close();
            stmt.close();
            conn.commit();
        }
        return out;
    }

    public TraceBuf2 extractFromBlob(byte[] tbBlob) throws DataFormatException {
        Inflater decompresser = new Inflater();
        decompresser.setInput(tbBlob, 0, tbBlob.length);
        ArrayList<byte[]> partialDecomp = new ArrayList<byte[]>();
        boolean decompFinished = false;
        int totalBytes = 0;
        while (!decompFinished) {
            if (totalBytes > 100000) {
                decompresser.end();
                throw new DataFormatException("WARNING, tracebuf decompress size has exceeded 100Kb, aborting...");
            }
            byte[] buffer = new byte[4096];
            int resultLength = decompresser.inflate(buffer);
            totalBytes += resultLength;
            if (resultLength < buffer.length) {
                byte[] tmp = new byte[resultLength];
                System.arraycopy(buffer, 0, tmp, 0, tmp.length);
                buffer = tmp;
            }
            partialDecomp.add(buffer);
            if (!decompresser.finished()) continue;
            decompFinished = true;
        }
        decompresser.end();
        byte[] finalResult = new byte[totalBytes];
        int position = 0;
        for (byte[] bs : partialDecomp) {
            System.arraycopy(bs, 0, finalResult, position, bs.length);
            position += bs.length;
        }
        return new TraceBuf2(finalResult);
    }

    public static Date j2KSecondsToDate(double j2kSeconds) {
        return new Date((long)(1000.0 * (j2kSeconds + 9.46728E8)));
    }

    public static double dateToJ2kSeconds(Date date) {
        return (double)date.getTime() / 1000.0 - 9.46728E8;
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static String prefixTableName(String prefix, String tableName) {
        return prefix + "_" + tableName;
    }

    Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.createConnection();
        }
        return this.conn;
    }

    void createConnection() throws SQLException {
        if (this.driverClass == null) {
            try {
                this.driverClass = Class.forName(this.driver);
                this.driverClass.newInstance();
            }
            catch (Exception e) {
                SQLException sql = new SQLException("Cannot create driver: " + this.driver);
                sql.initCause(e);
                throw sql;
            }
        }
        this.conn = DriverManager.getConnection(this.getDatabaseURL(), this.getUsername(), this.getPassword());
        this.conn.setAutoCommit(false);
    }

    public void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
    }

    public static String getUrlQueryParam(String name, String url) throws SeisFileException, URISyntaxException {
        String[] urlParts = url.split("\\?")[1].split("\\&");
        for (int i = 0; i < urlParts.length; ++i) {
            if (!urlParts[i].startsWith(name + "=")) continue;
            return urlParts[i].substring((name + "=").length());
        }
        throw new SeisFileException("Unable to find '" + name + "' query param in database url: " + url);
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose(boolean b) {
        verbose = b;
    }
}

